#include "I3DEngine.h"
#include "ITexture_info.h"

STRUCT_INFO_BEGIN(ParticleTarget)
	STRUCT_VAR_INFO(vTarget, TYPE_INFO(Vec3))
	STRUCT_VAR_INFO(vVelocity, TYPE_INFO(Vec3))
	STRUCT_VAR_INFO(bTarget, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bPriority, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bExtendLife, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bExtendCount, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bExtendSpeed, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bStretch, TYPE_INFO(bool))
STRUCT_INFO_END(ParticleTarget)

STRUCT_INFO_BEGIN(SIndirectLightingHeaderVersion2)
	STRUCT_VAR_INFO(version, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(objectSampleCount, TYPE_INFO(uint16))
	STRUCT_VAR_INFO(nChunkSize, TYPE_INFO(uint32))
STRUCT_INFO_END(SIndirectLightingHeaderVersion2)

STRUCT_INFO_TYPE_BEGIN(STerrainInfo)
	STRUCT_VAR_INFO(nHeightMapSize_InUnits, TYPE_INFO(int))
	STRUCT_VAR_INFO(nUnitSize_InMeters, TYPE_INFO(int))
	STRUCT_VAR_INFO(nSectorSize_InMeters, TYPE_INFO(int))
	STRUCT_VAR_INFO(nSectorsTableSize_InSectors, TYPE_INFO(int))
	STRUCT_VAR_INFO(fHeightmapZRatio, TYPE_INFO(float))
	STRUCT_VAR_INFO(fOceanWaterLevel, TYPE_INFO(float))
STRUCT_INFO_TYPE_END(STerrainInfo)

STRUCT_INFO_BEGIN(STerrainChunkHeader)
	STRUCT_VAR_INFO(nChunkVersion, TYPE_INFO(int))
	STRUCT_VAR_INFO(nChunkSize, TYPE_INFO(int))
	STRUCT_VAR_INFO(TerrainInfo, TYPE_INFO(STerrainInfo))
STRUCT_INFO_END(STerrainChunkHeader)

STRUCT_INFO_BEGIN(SVisAreaManChunkHeader)
	STRUCT_VAR_INFO(nChunkVersion, TYPE_INFO(int))
	STRUCT_VAR_INFO(nChunkSize, TYPE_INFO(int))
	STRUCT_VAR_INFO(nVisAreasNum, TYPE_INFO(int))
	STRUCT_VAR_INFO(nPortalsNum, TYPE_INFO(int))
	STRUCT_VAR_INFO(nOcclAreasNum, TYPE_INFO(int))
STRUCT_INFO_END(SVisAreaManChunkHeader)

STRUCT_INFO_BEGIN(SOcTreeNodeChunk)
	STRUCT_VAR_INFO(nChunkVersion, TYPE_INFO(int))
	STRUCT_VAR_INFO(nodeBox, TYPE_INFO(AABB))
	STRUCT_VAR_INFO(nObjectsBlockSize, TYPE_INFO(int))
	STRUCT_VAR_INFO(ucChildsMask, TYPE_INFO(uchar))
STRUCT_INFO_END(SOcTreeNodeChunk)

STRUCT_INFO_BEGIN(STerrainTextureFileHeader)
STRUCT_VAR_INFO(nLayerCount, TYPE_INFO(ushort))
STRUCT_VAR_INFO(dwFlags, TYPE_INFO(ushort))
STRUCT_VAR_INFO(m_fSunShadowIntensity, TYPE_INFO(float))
STRUCT_INFO_END(STerrainTextureFileHeader)

STRUCT_INFO_BEGIN(STerrainTextureLayerFileHeader)
	STRUCT_VAR_INFO(nSectorSizePixels, TYPE_INFO(ushort))
	STRUCT_VAR_INFO(nReserved, TYPE_INFO(ushort))
	STRUCT_VAR_INFO(eTexFormat, TYPE_INFO(ETEX_Format))
	STRUCT_VAR_INFO(nSectorSizeBytes, TYPE_INFO(uint32))
STRUCT_INFO_END(STerrainTextureLayerFileHeader)

STRUCT_INFO_BEGIN(CLoadingTimeProfiler)
	STRUCT_VAR_INFO(m_pTimeContainer, TYPE_POINTER(TYPE_INFO(CLoadingTimeContainer)))
	STRUCT_VAR_INFO(m_fConstructorTime, TYPE_INFO(double))
	STRUCT_VAR_INFO(m_fConstructorMemUsage, TYPE_INFO(double))
	STRUCT_VAR_INFO(m_pSystem, TYPE_POINTER(TYPE_INFO(ISystem)))
STRUCT_INFO_END(CLoadingTimeProfiler)

ENUM_INFO_BEGIN(EParticleBlendType)
	ENUM_ELEM_INFO(, ParticleBlendType_AlphaBased)
	ENUM_ELEM_INFO(, ParticleBlendType_ColorBased)
	ENUM_ELEM_INFO(, ParticleBlendType_Additive)
	ENUM_ELEM_INFO(, ParticleBlendType_None)
ENUM_INFO_END(EParticleBlendType)

STRUCT_INFO_BEGIN(SCommonFileHeader)
STRUCT_VAR_INFO(signature, TYPE_ARRAY(4, TYPE_INFO(char)))
STRUCT_VAR_INFO(type, TYPE_INFO(ushort))
STRUCT_VAR_INFO(version, TYPE_INFO(ushort))
STRUCT_INFO_END(SCommonFileHeader)
