////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek Studios, 2001-2006.
// -------------------------------------------------------------------------
//  File name:   XmlUtils.h
//  Created:     21/04/2006 by Timur.
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __XmlUtils_h__
#define __XmlUtils_h__
#pragma once

#include "ISystem.h"

//////////////////////////////////////////////////////////////////////////
// Implements IXmlUtils interface.
//////////////////////////////////////////////////////////////////////////
class CXmlUtils : public IXmlUtils, public ISystemEventListener
{
public:
	CXmlUtils( ISystem *pSystem );
	virtual ~CXmlUtils();

	//////////////////////////////////////////////////////////////////////////
	// IXmlUtils
	//////////////////////////////////////////////////////////////////////////

	virtual IXmlParser* CreateXmlParser();

	// Load xml file, return 0 if load failed.
	virtual XmlNodeRef LoadXmlFile( const char *sFilename );
	// Load xml from string, return 0 if load failed.
	virtual XmlNodeRef LoadXmlFromString( const char *sXmlString );	

	// create an MD5 hash of an XML file
	virtual const char * HashXml( XmlNodeRef node );

	// Get an object that can read a xml into a IReadXMLSink 
	// and write a xml from a IWriteXMLSource
	virtual IReadWriteXMLSink* GetIReadWriteXMLSink();

	virtual IXmlSerializer* CreateXmlSerializer();
	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////
	// ISystemEventListener
	//////////////////////////////////////////////////////////////////////////
	virtual void OnSystemEvent( ESystemEvent event,UINT_PTR wparam,UINT_PTR lparam );
	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////
	virtual void GetMemoryUsage( ICrySizer *pSizer );

	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

private:
	ISystem *m_pSystem;
	IReadWriteXMLSink*    m_pReadWriteXMLSink;
};

#endif //__XmlUtils_h__