#include "ZipFileFormat.h"

STRUCT_INFO_BEGIN(ZipFile::CDREnd)
	STRUCT_VAR_INFO(lSignature, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(nDisk, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nCDRStartDisk, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(numEntriesOnDisk, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(numEntriesTotal, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(lCDRSize, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(lCDROffset, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(nCommentLength, TYPE_INFO(ZipFile::ushort))
STRUCT_INFO_END(ZipFile::CDREnd)

STRUCT_INFO_BEGIN(ZipFile::DataDescriptor)
	STRUCT_VAR_INFO(lCRC32, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(lSizeCompressed, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(lSizeUncompressed, TYPE_INFO(ZipFile::ulong))
STRUCT_INFO_END(ZipFile::DataDescriptor)

STRUCT_INFO_BEGIN(ZipFile::CDRFileHeader)
	STRUCT_VAR_INFO(lSignature, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(nVersionMadeBy, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nVersionNeeded, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nFlags, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nMethod, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nLastModTime, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nLastModDate, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(desc, TYPE_INFO(ZipFile::DataDescriptor))
	STRUCT_VAR_INFO(nFileNameLength, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nExtraFieldLength, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nFileCommentLength, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nDiskNumberStart, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nAttrInternal, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(lAttrExternal, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(lLocalHeaderOffset, TYPE_INFO(ZipFile::ulong))
STRUCT_INFO_END(ZipFile::CDRFileHeader)

STRUCT_INFO_BEGIN(ZipFile::LocalFileHeader)
	STRUCT_VAR_INFO(lSignature, TYPE_INFO(ZipFile::ulong))
	STRUCT_VAR_INFO(nVersionNeeded, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nFlags, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nMethod, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nLastModTime, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nLastModDate, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(desc, TYPE_INFO(ZipFile::DataDescriptor))
	STRUCT_VAR_INFO(nFileNameLength, TYPE_INFO(ZipFile::ushort))
	STRUCT_VAR_INFO(nExtraFieldLength, TYPE_INFO(ZipFile::ushort))
STRUCT_INFO_END(ZipFile::LocalFileHeader)

