/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2003-2007 CRI-MW
 *
 *	Library	: ADX Library
 *	Module	: ADX Cinematic Sound System
 *	File	: cri_adxcs.h
 *	Create	: 2003-05-21
 *
 ***************************************************************************/

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef _ADXCS_H_INCLUDED
#define _ADXCS_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXCS_VER	"1.23"

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <cri_xpt.h>
#include <cri_adxt.h>
#include <cri_aixp.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/

/* nhiADXT܂AIXPj̍ő吔				*/
/* The maximum number of internal handles(ADXT or AIXP)	*/
#define ADXCS_MAX_INTERNAL_HNDL			(2)


/* tF[hAEgԂ̃ftHgl		*/
/* The default value of fade-out time	*/
#define ADXCS_DEF_FADE_OUT_TIME			(30)				/* 0.5sec	*/

/* tF[hCԂ̃ftHgl		*/
/* The default value of fade-in time	*/
#define ADXCS_DEF_FADE_IN_TIME			(0)

/* {[ύXԂ̃ftHgl			*/
/* The default value of volume change time	*/
#define ADXCS_DEF_VOL_CHANGE_TIME		(0)

/* tF[hCJnItZbg̃ftHgl				*/
/* The default value of offset of fade-in start time	*/
/* from fade-out start time								*/
#define ADXCS_DEF_FADE_IN_START_OFFSET	(0)

/* tF[h̃fBCԂ̃ftHgl	*/
/* The default value of fade-end delay		*/
#define ADXCS_DEF_FADE_END_DELAY		(60)				/* 1sec		*/

/* tF[hԂ̍ŏl				*/
/* The minimum value of fading time	*/
#define ADXCS_FADE_TIME_MIN				(0)

/* tF[hԂ̍ől				*/
/* The maximum value of fading time	*/
#define ADXCS_FADE_TIME_MAX				(1800)				/* 30sec	*/


/* {CXnCCg̃{[Ԃ̃ftHgl			*/
/* The default value of volume decrease time of Voice-Highlight	*/
#define ADXCS_DEF_VHL_DEC_TIME			(30)				/* 0.5sec	*/

/* {CXnCCg̃{[Ԃ̃ftHgl			*/
/* The default value of volume increase time of Voice-Highlight	*/
#define ADXCS_DEF_VHL_INC_TIME			(60)				/* 1sec		*/

/* {CXnCCg̃{[ʂ̃ftHgl						*/
/* The default value of quantity of volume decrease of Voice-Highlight	*/
#define ADXCS_DEF_VHL_DEC_VOL			(120)				/* 12dB		*/


/* ADXCSnh̍Đ			*/
/* Playing state of a ADXCS handle	*/
#define ADXCS_STAT_STOP			(0)	/* ~			(Stop)				*/
#define ADXCS_STAT_PREP			(1) /* Đ		(Prepare playing)	*/
#define ADXCS_STAT_PLAYING		(2) /* fR[hĐ	(Decoding & Playing)*/
#define ADXCS_STAT_PLAYEND		(3) /* ĐI			(End of playback)	*/
#define ADXCS_STAT_ERROR		(4) /* G[		(Error)				*/

/* ADXCSnh̃tF[h		*/
/* Fading state of a ADXCS handle	*/
#define ADXCS_FADE_STAT_IDLE	(0)	/* x~			(Idle state)		*/
#define ADXCS_FADE_STAT_FADING	(1)	/* tF[h		(Processing fading)	*/

/* TEh̎	*/
/* Type of sound	*/
#define ADXCS_SND_TYPE_NONE		(0)	/* 			(Independent)		*/
#define ADXCS_SND_TYPE_BGM		(1)	/* BGM				(Background music)	*/
#define ADXCS_SND_TYPE_VOICE	(2)	/* Zt			(Voice)				*/
#define ADXCS_SND_TYPE_SE		(3)	/* ʉ			(Sound effect)		*/

/* R[obN֐̎		*/
/* Type of callback function	*/
#define ADXCS_CB_START_FADE_OUT		(0) /* tF[hAEgJn				*/
										/* Start of fade-out				*/
#define ADXCS_CB_START_FADE_IN		(1) /* tF[hCJn					*/
										/* Start of fade-in					*/
#define ADXCS_CB_START_VOL_CHANGE	(2) /* tF[h{[`FWJn	*/
										/* Start of volume chage			*/
#define ADXCS_CB_END_FADE_OUT		(3) /* tF[hAEgI				*/
										/* End of fade-out					*/
#define ADXCS_CB_END_FADE_IN		(4) /* tF[hCI					*/
										/* End of fade-in					*/
#define ADXCS_CB_END_VOL_CHANGE		(5) /* {[ύXI				*/
										/* End of volume change				*/
#define ADXCS_CB_END_FADE_ALL		(6) /* StF[hI					*/
										/* End of all process of fading		*/

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/* ADXCSnh	*/
/* ADXCS Handle		*/
#ifndef ADXCS_DEFINED
#define ADXCS_DEFINED
typedef void *ADXCS;
#endif

/* nh쐬p[^		*/
/* Handle creation parameter	*/
typedef struct {
	Sint32	max_stm;		/* ő哯ĐfBXNXg[				*/
							/* Maximum number of stream which play at the	*/
							/* same time									*/
	Sint32	max_ch;			/* ő`l								*/
							/* Maximum number of channel					*/
	Sint32	max_sfreq;		/* őTvOg						*/
							/* Maximum sampling frequency					*/
	Sint32	max_aix_track;	/* AIX̍őgbN							*/
							/* Maximum number of track of AIX				*/ 
	Sint32	play_method;	/* Đ(ADXT_PLY_MEM / ADXT_PLY_STM)		*/
							/* Playback method(ADXT_PLY_MEM / ADXT_PLY_STM)	*/
	Sint8	sound_type;		/* TEh̎								*/
							/* Type of sound								*/
	Bool	use_crossfade;	/* NXtF[h邩ۂ					*/
							/* Whether handle can use crossfade function	*/
	Bool	use_aix;		/* AIXgp邩ۂ							*/
							/* Whether handle can use AIX playback function	*/
	Bool	use_ahx;		/* AHXgp邩ۂ							*/
							/* Whether handle can use AHX playback function	*/
	Bool	use_3d_panning;	/* A^C3DpjOgp邩ۂ		*/
							/* Whether handle can use realtime 3D panning	*/
} AdxcsCrePrm;

/* 
 * ӁF
 * A^C3DpjOgpꍇiuse_3d_panningTRUEjAő`l
 * ͖AvbgtH[ŗL̒lɂȂ܂B
 * ܂ÂƂ͉\ȉ̓m݂̂łB
 * Notice:
 * If you want to use 3D panning(use_3d_panning flag is TRUE), maximum number
 * of channel(max_ch) is ignored. It is set to the platform's unique value
 * internally.
 * And then, only a monaural sound can be inputted.
 */

/***************************************************************************
 *      ϐ錾
 *      Prototype Functions
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------
 *      EI
 *		Initialization / Finish
 *-------------------------------------------------------------------------*/
/* 						*/
/* Initializes the ADXCS library	*/
void CRIAPI ADXCS_Init(void);

/* I						*/
/* Finishes	the ADXCS library	*/
void CRIAPI ADXCS_Finish(void);


/*--------------------------------------------------------------------------
 *      nh̍쐬Ej
 *		Handle Creation / Destruction
 *-------------------------------------------------------------------------*/
/* ADXCSnh̍쐬		*/
/* Creates a ADXCS handle	*/
ADXCS CRIAPI ADXCS_Create(const AdxcsCrePrm *cprm,
						  Sint8 *work, Sint32 work_size);

/* ADXCSnh̔j		*/
/* Destroys a ADXCS handle	*/
void CRIAPI ADXCS_Destroy(ADXCS adxcs);


/* [N̈TCYvZ			*/
/* Calculates the work size of a handle	*/
Sint32 CRIAPI ADXCS_CalcWorkCprm(const AdxcsCrePrm *cprm);


/* AHXĐ@\̑gݍ					*/
/* Attaches the function of AHX playback	*/
void CRIAPI ADXCS_AttachAhx(ADXCS adxcs);

/* AHXĐ@\̕						*/
/* Detaches the function of AHX playback	*/
void CRIAPI ADXCS_DetachAhx(ADXCS adxcs);


/*--------------------------------------------------------------------------
 *      {Đ
 *		Basic Playback
 *-------------------------------------------------------------------------*/
/* t@CwɂĐ̊Jn			*/
/* Starts a playback by specified filename	*/
void CRIAPI ADXCS_StartFname(ADXCS adxcs, const Char8 *fname);

/* t@CwɂĐ̊Jni͈͎wtj					*/
/* Starts a playback by specified filename and the range as sector 	*/
void CRIAPI ADXCS_StartFnameRange(ADXCS adxcs, const Char8 *fname, Sint32 ofst, Sint32 nsct);

/* AFSt@CFIDwɂĐ̊Jn			*/
/* Starts a playback by specified FID in a AFS file	*/
void CRIAPI ADXCS_StartAfs(ADXCS adxcs, Sint32 patid, Sint32 fid);

/* t@C̍Đ̊Jn									*/
/* Starts a playback by specified address of a file in memory	*/
void CRIAPI ADXCS_StartMem(ADXCS adxcs, void *dat, Sint32 datlen);

/* CfbNXwɂĐ̊Jn									*/
/* Starts a playback by specified index and address of a ACX data in memory	*/
void CRIAPI ADXCS_StartMemIdx(ADXCS adxcs, void *acx, Sint32 no);

/* Đ̒~		*/
/* Stops a playback	*/
void CRIAPI ADXCS_Stop(ADXCS adxcs);

/* ꎞ~̐ݒ				*/
/* Pauses or cancels pausing	*/
void CRIAPI ADXCS_Pause(ADXCS adxcs, Sint32 sw);

/* ꎞ~Ԃ̎擾	*/
/* Gets pausing state	*/
Sint32 CRIAPI ADXCS_GetStatPause(ADXCS adxcs);

/* ĐԂ̎擾		*/
/* Gets playing state	*/
Sint32 CRIAPI ADXCS_GetStat(ADXCS adxcs);


/*--------------------------------------------------------------------------
 *      p[^ݒ
 *		Parameter Settings
 *-------------------------------------------------------------------------*/
/* nh쐬p[^̎擾		*/
/* Gets a handle creation parameter	*/
const AdxcsCrePrm *CRIAPI ADXCS_GetCprm(ADXCS adxcs);

/* [vtO̐ݒ	*/
/* Sets the loop flag	*/
void CRIAPI ADXCS_SetLpFlg(ADXCS adxcs, Sint32 flg);

/* TEh̎ނ̐ݒ	*/
/* Sets the type of sound	*/
void CRIAPI ADXCS_SetType(ADXCS adxcs, Sint32 type);

/* TEh̎ނ̎擾	*/
/* Gets the type of sound	*/
Sint32 CRIAPI ADXCS_GetType(ADXCS adxcs);


/* o̓{[̐ݒ	*/
/* Sets a output volume	*/
void CRIAPI ADXCS_SetOutVol(ADXCS adxcs, Sint32 vol);

/* o̓{[̎擾	*/
/* Gets a output volume	*/
Sint32 CRIAPI ADXCS_GetOutVol(ADXCS adxcs);

/* Đ̏o̓{[̐ݒ			*/
/* Sets a output volume of next playback	*/
void CRIAPI ADXCS_SetOutVolNextPlayback(ADXCS adxcs, Sint32 vol);

/* gbNƂ̏o̓{[̐ݒ	*/
/* Sets a output volume of each track	*/
void CRIAPI ADXCS_SetTrackVol(ADXCS adxcs, Sint32 trno, Sint32 vol);

/* gbNƂ̏o̓{[̎擾	*/
/* Gets a output volume of each track	*/
Sint32 CRIAPI ADXCS_GetTrackVol(ADXCS adxcs, Sint32 trno);


/* tF[hAEgԂ̐ݒiV-SyncPʁj	*/
/* Sets a time of fade-out(V-Sync)			*/
void CRIAPI ADXCS_SetFadeOutTime(ADXCS adxcs, Sint32 time);

/* tF[hAEgԂ̎擾iV-SyncPʁj	*/
/* Gets a time of fade-out(V-Sync)			*/
Sint32 CRIAPI ADXCS_GetFadeOutTime(ADXCS adxcs);

/* tF[hCԂ̐ݒiV-SyncPʁj	*/
/* Sets a time of fade-in(V-Sync)		*/
void CRIAPI ADXCS_SetFadeInTime(ADXCS adxcs, Sint32 time);

/* tF[hCԂ̎擾iV-SyncPʁj	*/
/* Gets a time of fade-in(V-Sync)		*/
Sint32 CRIAPI ADXCS_GetFadeInTime(ADXCS adxcs);

/* {[ύXԂ̐ݒiV-SyncPʁj	*/
/* Sets a time of volume change(V-Sync)		*/
void CRIAPI ADXCS_SetVolChangeTime(ADXCS adxcs, Sint32 time);

/* {[ύXԂ̎擾iV-SyncPʁj	*/
/* Gets a time of volume change(V-Sync)		*/
Sint32 CRIAPI ADXCS_GetVolChangeTime(ADXCS adxcs);


/* tF[hAEg̑΃tF[hCJn̐ݒiV-SyncPʁj			*/
/* Sets a offset of a fade-in start time from a fade-out start time(V-Sync)	*/
void CRIAPI ADXCS_SetFadeInStartOffset(ADXCS adxcs, Sint32 offset);

/* tF[hAEg̑΃tF[hCJn̎擾iV-SyncPʁj			*/
/* Gets a offset of a fade-in start time from a fade-out start time(V-Sync)	*/
Sint32 CRIAPI ADXCS_GetFadeInStartOffset(ADXCS adxcs);


/* tF[h̃fBCԂ̐ݒiV-SyncPʁj */
/* Sets a fade-end delay time(V-Sync)			*/
void CRIAPI ADXCS_SetFadeEndDelay(ADXCS adxcs, Sint32 delay);

/* tF[h̃fBCԂ̎擾iV-SyncPʁj */
/* Gets a fade-end delay time(V-Sync)			*/
Sint32 CRIAPI ADXCS_GetFadeEndDelay(ADXCS adxcs);


/*--------------------------------------------------------------------------
 *      nh̎擾
 *		Getting Internal Handle
 *-------------------------------------------------------------------------*/
/* ݃ANeBuȓADXTnh擾			*/
/* Gets a internal ADXT handle which is active now	*/
ADXT CRIAPI ADXCS_GetActiveAdxt(ADXCS adxcs);

/* ɐ؂ւ\̓ADXTnh擾							*/
/* Gets a internal ADXT handle which will be changed at a next start	*/
ADXT CRIAPI ADXCS_GetNextAdxt(ADXCS adxcs);

/* CfbNXwœADXTnh擾	*/
/* Gets a internal ADXT handle from index	*/
ADXT CRIAPI ADXCS_GetAdxt(ADXCS adxcs, Sint32 index);

/* ADXTnh̐擾				*/
/* Gets the number of internal ADXT handles	*/
Sint32 CRIAPI ADXCS_GetNumAdxt(ADXCS adxcs);


/* ݃ANeBuȓAIXPnh擾			*/
/* Gets a internal AIXP handle which is active now	*/
AIXP CRIAPI ADXCS_GetActiveAixp(ADXCS adxcs);

/* ɐ؂ւ\̓AIXPnh擾							*/
/* Gets a internal AIXP handle which will be changed at a next start	*/
AIXP CRIAPI ADXCS_GetNextAixp(ADXCS adxcs);

/* CfbNXwœAIXPnh擾	*/
/* Gets a internal AIXP handle from index	*/
AIXP CRIAPI ADXCS_GetAixp(ADXCS adxcs, Sint32 index);

/* AIXPnh̐擾				*/
/* Gets the number of internal AIXP handles	*/
Sint32 CRIAPI ADXCS_GetNumAixp(ADXCS adxcs);


/*--------------------------------------------------------------------------
 *      tF[h
 *		Fading Process
 *-------------------------------------------------------------------------*/
/* tF[hLZČ̉ʂɖ߂			*/
/* Cancels the fading process and turns the volume back	*/
void CRIAPI ADXCS_CancelFading(ADXCS adxcs);

/* tF[hԂ̎擾		*/
/* Gets the fading state	*/
Sint32 CRIAPI ADXCS_GetFadeStat(ADXCS adxcs);

/* tF[hIR[obN֐̓o^			*/
/* Registers the function of fade-end callback	*/
void CRIAPI ADXCS_SetCbFunc(ADXCS adxcs,
							void (*fn)(ADXCS adxcs, Sint32 cb_type));

/*--------------------------------------------------------------------------
 *      {CXnCCg
 *		Voice-Highlight
 *-------------------------------------------------------------------------*/
/* {CXnCCg@\Lɂ		*/
/* Enables the Voice-Highlight function	*/
void CRIAPI ADXCS_EnableVhl(void);

/* {CXnCCg@\𖳌ɂ			*/
/* Disables the Voice-Highlight function	*/
void CRIAPI ADXCS_DisableVhl(void);


/* {[ɗv鎞Ԃݒ肷iV-SyncPʁj	*/
/* Sets the time(V-Sync) of the volume decrease			*/
void CRIAPI ADXCS_SetVhlDecTime(Sint32 dec_time);

/* {[ɗv鎞Ԃ擾iV-SyncPʁj	*/
/* Gets the time(V-Sync) of the volume decrease			*/
Sint32 CRIAPI ADXCS_GetVhlDecTime(void);

/* {[ɗv鎞Ԃݒ肷iV-SyncPʁj	*/
/* Sets the time(V-Sync) of the volume increase			*/
void CRIAPI ADXCS_SetVhlIncTime(Sint32 inc_time);

/* {[ɗv鎞Ԃ擾iV-SyncPʁj	*/
/* Gets the time(V-Sync) of the volume increase			*/
Sint32 CRIAPI ADXCS_GetVhlIncTime(void);

/* {[ʂݒ肷		*/
/* Sets the quantity of the volume decrease	*/
void CRIAPI ADXCS_SetVhlDecVol(Sint32 dec_vol);

/* {[ʂ擾		*/
/* Gets the quantity of the volume decrease	*/
Sint32 CRIAPI ADXCS_GetVhlDecVol(void);

/*--------------------------------------------------------------------------
 *      T[o
 *		Server Process
 *-------------------------------------------------------------------------*/
/* T[o				*/
/* Executes server process	*/
void CRIAPI ADXCS_ExecServer(void);

/* nh̃T[o					*/
/* Executes server process of each handle	*/
void CRIAPI ADXCS_ExecHndl(ADXCS adxcs);

#ifdef __cplusplus
}
#endif


#endif		/* #ifndef _ADXCS_H_INCLUDED */

/* end of file */
