/***********************************************************************
 *
 *  Software Library
 *  Copyright (c) 2001-2007 CRI-MW
 *
 *      Read Only File System
 *
 *  Module  : Library Header File
 *  File    : cri_rofs.h
 *  Author  : Nagayasu Takuya
 *  Modify  : Mikoshiba Kengo
 *  Date    : 2007-03-22
 *  Version : see (ROFS_VERSION_STR)
 *  Notes   : 
 *
 ***********************************************************************/

/*---------------------------------------------------------------------*/
#ifndef _CRI_ROFS_H_
#define _CRI_ROFS_H_

/*****************************************************************************
 *      CN[ht@C
 *		Include file
 *****************************************************************************/

/*---------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <cri_xpt.h>

#ifndef CRI_XPT_H
	Please include "cri_xpt.h"		/* \h */
									/* Prevention */
#endif

/*****************************************************************************
 *      萔}N
 *		Macro Constant
 *****************************************************************************/

/* o[Wԍ */
/* Version Number */
#define ROFS_VERSION_STR		"1.91"		/* Version number */

/* ZN^ */
/* Sector Length */
#define ROFS_SCT_LEN			(2048)

/* t@C */
/* File Attribute */
#define ROFS_ATR_DIRECTORY		(0x02)		/* fBNg */
											/* Directory */

/* {[ */
/* Volume name */
#define ROFS_VOLNAME_LEN		(8)
#define ROFS_VOLNAME_SIZ		(ROFS_VOLNAME_LEN + 1)

/* t@C */
/* File name */
#define ROFS_FNAME_LEN			(31)
#define ROFS_FNAME_SIZ			(ROFS_FNAME_LEN + 1)

/* fBNg */
/* Directory name */
#define ROFS_DIRNAME_LEN		(31)
#define RPFS_DIRNAME_SIZ		(ROFS_DIRNAME_LEN+1)

/* {[ID */
/* Volume ID */
#define ROFS_VOLID_SIZ			(8)

/* CVM^CX^v */
/* Time stamp of CVM */
#define ROFS_TMSTMP_SIZ			(8)

/* ƃobt@ */
/* Work buffer */
#define ROFS_WKBUF_NUM			(2)
#define ROFS_WKBUF_SIZ			(ROFS_SCT_LEN * ROFS_WKBUF_NUM + 64)


/*============================================================================
 *      ROFS_SetCond֐p̃p[^
 *		Parameters for the ROFS_SetCond function
 *===========================================================================*/
/* fBNgR[h\[X	*/
/* Directory record source		*/
#define ROFS_PARM_DIRSRC_DFL	(0)		/* default						*/
#define ROFS_PARM_DIRSRC_CVM	(0)		/* from CVM						*/
#define ROFS_PARM_DIRSRC_MEM	(1)		/* from direcotry record file	*/

/*****************************************************************************
 *      񋓒萔
 *		Enumarate Constants
 *****************************************************************************/

/* t@Cnh */
/* Status of handle */
typedef enum {
	ROFS_STAT_IDLE		= (0),			/* Idle status */
	ROFS_STAT_COMPLETE	= (1),			/* Tranfer complete status */
	ROFS_STAT_TRANS		= (2),			/* During transfer status */
	ROFS_STAT_ERR		= (3),			/* Error outbreak status */
	ROFS_STAT_NUM
} RofsStat;

/* V[N[h */
/* Mode of seek */
typedef enum {
	ROFS_SEEK_SET		= (0),			/* Top of file */
	ROFS_SEEK_CUR		= (1),			/* Current position */
	ROFS_SEEK_END		= (2),			/* End of file */
	ROFS_SEEK_NUM
} RofsSeek;

/* G[R[h */
/* Error code */
typedef enum {
	ROFS_ERR_OK			= (0),			/* I */
										/* Successful */
	ROFS_ERR_NG			= (-1),			/* s */
										/* Failure */

	ROFS_ERR_PRM		= (-100),		/* p[^̐ݒG[ */
										/* Error of parameter */
	ROFS_ERR_ILLHDL		= (-101),		/* t@Cnhs */
										/* Illigal file handle */
	ROFS_ERR_NOHNDL		= (-102),		/* t@Cnhɋ󂫂Ȃ */
										/* Too many file handles */
	ROFS_ERR_VOLNAME	= (-103),		/* sȃ{[ */
										/* Illigal volume name */
	ROFS_ERR_REGVOLNAME	= (-104),		/* o^ς݂̃{[ */
										/* Already exist volume name */
	ROFS_ERR_VOLUME		= (-105),		/* {[̖G[ */
										/* Invalid Volume */
	ROFS_ERR_NOTDIR		= (-106),		/* fBNgłȂ̂w肵 */
										/* Not directory*/
	ROFS_ERR_NOTFOUND	= (-107),		/* ݂Ȃt@C */
										/* No exist file */
	ROFS_ERR_ILLDIRBUF	= (-108),		/* sȃfBNgR[h */
										/* Illigal directory record */
	ROFS_ERR_DIROVER	= (-109),		/* fBNgGg̍ő吔𒴂 */
										/* Too many entry of directory */
	ROFS_ERR_NOTFOUND_TOD	= (-110),	/* fBNgR[h̏I[Ȃ */
										/* Termination of a directory record is not found */
	ROFS_ERR_INVALID_DIRLIST= (-111),	/* ȃfBNgXg */
										/* Invalid directory list */

	ROFS_ERR_BUSY		= (-200),		/* ̃R}hs */
										/* Under processing of other commands */
	ROFS_ERR_TOUT		= (-201),		/* Ń^CAEg */
										/* Timeout */
	ROFS_ERR_PRIMITIVE	= (-202),		/* v~eBu֐G[ */
										/* Primitive function error */
	ROFS_ERR_INIT		= (-203),		/* G[ */
										/* Initialization error */
	ROFS_ERR_REQRD		= (-204),		/* ǂݍݗvG[ */
										/* Read request error */
	ROFS_ERR_SEEK		= (-205),		/* V[NG[ */
										/* Seek error */
	ROFS_ERR_OPEN		= (-206),		/* t@CI[vG[ */
										/* File open error */
	ROFS_ERR_READ		= (-207),		/* ǂݍ݃G[ */
										/* Read error */

	ROFS_ERR_INTERNAL	= (-1000)		/* G[ */
										/* Internal error */
} RofsErr;

/* ID */
/* operating condition id */
typedef enum {
	ROFS_COND_DIRSRC		= (0),	/* fBNgR[h\[X	*/
									/* directory record source		*/
	ROFS_COND_ECB_READ		= (1),	/* [hG[R[obN		*/
									/* read error call back			*/
	ROFS_COND_ECB_LOADDIR	= (2),	/* [hfBNgR[obN	*/
									/* load directory error call back	*/
	ROFS_COND_END
} RofsCondId;

/*****************************************************************************
 *      }N
 *		Process Macro
 *****************************************************************************/
/* CuƗ̈TCY */
/* Library work area size */
#define ROFS_GET_LIBWORK_SIZ(max_open, max_volume, max_dirent) \
	(sizeof(RofsWork)+((max_open)+1)*sizeof(RofsHandle)+\
	(ROFS_GET_DIRREC_SIZ(max_dirent)+sizeof(RofsVolume))*(max_volume)+8)

/* fBNgR[ḧTCY */
/* Directory record area size */
#define ROFS_GET_DIRREC_SIZ(n_dirent) \
	(sizeof(RofsDirRec)-sizeof(RofsDirRecEnt)+(n_dirent)*sizeof(RofsDirRecEnt))

/* fBNg̔ */
/* judgment of a directory */
#define ROFS_IS_ATR_DIRECTORY(finf) \
	(((finf)->fatr & ROFS_ATR_DIRECTORY)?TRUE:FALSE)

/* ZN^oCgւ̕ϊ */
/* Conversion to the byte number from the sector number */
#define ROFS_CONV_SCT2BYTE(n_sct)	((n_sct) * ROFS_SCT_LEN)

/* ZN^ǂݍ݃obt@TCY */
/* Sector reading buffer size */
#define ROFS_GET_SCTBUF_SIZ(n_sct)	(ROFS_CONV_SCT2BYTE(n_sct) + 63)

/* |C^64byteE킹 */
/* 64-byte boundary of a pointer */
#define ROFS_ALIGN_64BYTE(ptr)		(((Sint32)(ptr) + 63) & 0xffffffc0)

/*****************************************************************************
 *      f[^^̒`
 *		Data type declaration
 *****************************************************************************/
/* [N̈ */
/* Work area */
typedef struct RofsStWrok		RofsWork;

/* v~eBu֐e[u */
/* Primitive functions table */
typedef struct RofsPfsIfTbl		RofsPfsTbl;

/* foCXRg[֐ */
/* Device control functions */
typedef struct RfpfsDevIfTbl	RofsDevTbl;

/* CuC^[tF[X֐e[u */
/* Library interface functions table */
typedef struct RfmaiLibIfTbl	RofsLif;

/* fBNgR[hGg */
/* Directory record entry */
typedef struct {
	Uint32	fsize;						/* file size lower */
	Uint32	fsize_ex;					/* file size upper */
	Sint32	fad;						/* fad */
	Uint8	fatr;						/* file attribute */
	Uint8	sid;						/* filename search id */
	Char8	fname[ROFS_FNAME_SIZ];		/* filename */
	Uint8	pad[2];						/* align padding */
} RofsDirRecEnt;	/* 48 bytes */

/* fBNgR[h */
/* Directory record */
typedef struct {
	Sint32	dir_num;					/* number of record */
	Sint32	max_ent;					/* max entry of directory record */
	Sint32	dir_fad;					/* fad of directory record */
	Char8	volname[ROFS_VOLNAME_SIZ];	/* volume name */
	Uint8	pad[3];						/* align padding */
	RofsDirRecEnt	dirrec_tbl[1];		/* record table */
} RofsDirRec;		/* 24 bytes */
typedef RofsDirRec	*RofsDirRecBuf;

/* {[Ǘ */
/* Volume management */
typedef struct {
	void	*img_hn;					/* file handle of the CVM file */
	Sint32	zisb;						/* image start position (0 = DVD-ROM) */
	Sint32	ptbl_cba;					/* cba of path table */
	Sint32	ptbl_size;					/* size of path table */
	RofsDirRecBuf	curdir;				/* current directory handle */
	Sint16	req_cnt;					/* request counter */
	Char8	volname[ROFS_VOLNAME_SIZ];	/* volume name */
	Uint8	pad[1];						/* align padding */
	/* 2002-09-26 Ver.1.30 miko { : CVMtH[}bgύX */
	Uint32	flags;						/* flags */
	Uint8	vol_id[ROFS_VOLID_SIZ];		/* volume id */
	/* } */
	/* 2003-05-27 Ver.1.60 miko { : dirlstΉ */
	Uint8	vol_cvmtim[ROFS_TMSTMP_SIZ];	/* volume time stamp */
	/* } */
} RofsVolume;		/* 52 bytes */

/* ROFSt@Cnh */
/* ROFS File Handle */
typedef struct {
	Uint32		fsize;					/* file size lower */
	Uint32		fsize_ex;				/* file size upper */
	RofsWork	*wk;					/* pointer of lib work */
	Sint32		fid;					/* file id */
	Sint32		fad;					/* fad */
	Sint32		ofs;					/* offset */
	Sint32		fsctsize;				/* sctor size of the file */
	RofsVolume	*vol;					/* image file volume */
	Sint32		rsize;					/* reading size */
	Sint32		trns_seg;				/* transferred block unit */
	Sint32		trns_ofs;				/* transferred byte unit */
	Sint32		trns_unit;				/* transfer unit (block) */
	Uint8		*rdadr;					/* read address */
	Sint16		used;					/* used flag */
	Sint16		act;					/* handle act */
	Sint16		stat;					/* handle status(RofsStat) */
	Sint16		err;					/* error status */
} RofsHandle;		/* 72 bytes */
typedef RofsHandle	*Rofs;

/* ROFSƗ̈ */
/* ROFS Work Area */
struct RofsStWrok {
	Bool			f_init;				/* initialize flag */
	Sint32			max_open;			/* max open files */
	Sint32			max_volume;
	Sint32			max_dirent;
	Sint32			worksiz;
	Uint32			exec_server_cnt;	/* counter */
	Uint32			actflags;
	Uint32			tout_read_max;
	Rofs			syshdl;				/* handle for system command */
	Rofs			hndtbl;				/* handle */
	RofsVolume		*vollist;			/* Volume information list */
	RofsVolume		*curvol;			/* information of the defalut Volume */
	RofsDirRecBuf	dirbuf;				/* start posision of directory record */
	RofsPfsTbl		*pfs;				/* primitive function table */
	RofsDevTbl		*dev;				/* device control function table */
	RofsLif			*liftbl;			/* library interface */
	void	(*g_errcb)(void *, Char8 *, Sint32);	/* error callback */
	void			*g_errcb_1st;		/* error callback 1st arg. */
	Uint32			*sctbuf;			/* sector buffer addres */
	Uint32	sct_load_buf[ROFS_WKBUF_SIZ / 4];	/* sector buffer */
	RofsHandle		hndlist[1];			/* handle table */
}; /* 76 + 4160 + (72 * (handle num + 1)) */

/* Cu  */
/* Library initialize information */
typedef struct {
	Sint32	max_open;			/* ɃI[vłőt@C */
								/* The number of the maximum files 
								 * which can be opened simultaneously */
	Sint32	max_volume;			/* ɓo^łő{[ */
								/* The number of the maximum volumes 
								 * which can be registered simultaneously */
	Sint32	max_dirent;			/* fBNgɊi[őt@C */
								/* The number of the maximum files 
								 * stored in a directory */
	void	*rofs_work;			/* CuƗ̈̐擪AhX */
								/* The head address of a library work domain */
} RofsInitPara;

/* t@C */
/* File information */
typedef struct {
	Uint32	fsize;					/* file size lower */
	Uint32	fsize_ex;				/* file size upper */
	Char8	*fname;					/* file name */
	Uint8	fatr;					/* file attribute */
	Uint8	pad[3];					/* align padding */
} RofsFileInf;		/* 16 bytes */

/* {[ */
/* Volume information */
typedef struct {
	Char8	*volname;				/* volume name */
	void	*fhn;					/* file handle of the volume */
} RofsVolumeInf;

/* 2002-10-24 Ver.1.330 miko : add -> 2005-11-15 update */
/* XNu */
/* Scramble information */
typedef struct {
	RofsVolume	*vol;				/* image file volume */
	Sint32		sctno;				/* sector number */
} RofsScrambleInf;

/* 2002-11-06 Ver.1.400 miko : add */
/* {[p[^ */
/* Volume parameter */
typedef struct {
	Char8	*scrkey;				/* XNũ|C^ */
									/* The pointer of descramble string */
} RofsVolumePrm;

/* G[R[obN֐ */
/* Error callback function */
typedef void (*RofsErrFunc)(void *obj, Char8 *msg, Sint32 errcode);

/* v~eBu֐e[u */
/* Primitive functions table */
struct RofsPfsIfTbl {
	void		(*pfs_execserver)(void);
	void		(*pfs_reserve01)(RofsErrFunc, void *);
	Sint32		(*pfs_reserve02)(Sint8 *);
	Sint32		(*pfs_reserve03)(void);
	void		*(*pfs_reserve04)(Sint8 *, void *, Sint32);
	void		(*pfs_reserve05)(void *);
	Sint32		(*pfs_seek)(void *, Sint32, RofsSeek);
	Sint32		(*pfs_tell)(void *);
	Sint32		(*pfs_reqrd)(void *, Sint32, void *);
	Sint32		(*pfs_reserve07)(void *, Sint32, void *);
	void		(*pfs_stoptr)(void *);
	Sint32		(*pfs_getstat)(void *);
	Sint32		(*pfs_getsctlen)(void *);
	void		(*pfs_reserve08)(void *, Sint32);
	Sint32		(*pfs_getnumtr)(void *);
	Sint32		(*pfs_reserve09)(Sint8 *);
	Sint32		(*pfs_reserve10)(Sint8 *);
	Sint32		(*pfs_reserve11)(void);
	Sint32		(*pfs_reserve12)(Sint8 *, void *, Sint32);
	Sint32		(*pfs_reserve13)(void *);
	Sint32		(*pfs_reserve14)(Sint8 *);
	Sint32		(*pfs_reserve15)(Sint8 *);
	Sint32		(*pfs_reserve16)(Sint8 *);
	Sint32		(*pfs_reserve17)(Sint8 *, void *);
	Sint32		(*pfs_reserve18)(void *, Sint32, Sint32, Sint32);
	Sint32		(*pfs_reserve19)(void *, Sint32, Sint32, Sint32);
	/* 2002-09-11 Ver.1.22a miko { : 64bitΉ */
	Sint64		(*pfs_getnumtr64)(void *);
	/* } miko */
};

/*****************************************************************************
 *      ϐ錾
 *		Variable Declaration
 *****************************************************************************/

/*****************************************************************************
 *      ֐錾
 *		Function Declaration
 *****************************************************************************/

/*============================================================================
 *      Cu^I
 *		Initialize and Finalize of Library
 *===========================================================================*/
/* t@CVXȅ
 * [  ] init_para	: Cup[^
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 * (a) CuƗ̈ ROFS_GET_LIBWORK_SIZ}N ŋ߂邱ƁB
 * (b) init_para.max_dirent ́A"."".."̂QZ邱ƁB
 */
/* Initialize of file system
 * [Inputs ] init_para	: Library initialization parameter
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 * (a) Decides the library work area size by ROFS_GET_LIBWORK_SIZ.
 * (b) init_para.max_dirent should add a part for two of "." and "..".
 */
RofsErr CRIAPI		ROFS_Init(RofsInitPara *init_para);

/* t@CVXȅI
 * [  ] Ȃ
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 */
/* Finalyze of file syste
 * [Inputs ] none
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 */
void CRIAPI		ROFS_Finish(void);

/* v~eBu֐̓o^
 * [  ] pfs_tbl		: v~eBu֐e[u
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 * (a) ftHgłCRI-MWW̊֐o^ĂB
 */
/* Registration of a primitive function
 * [Inputs ] 
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 * (a) The standard function for CRI-MW is registered by the default.
 */
RofsErr CRIAPI		ROFS_SetPfsFuncTbl(RofsPfsTbl *pfs_tbl);

/*============================================================================
 *      {[
 *		Handle Volume
 *===========================================================================*/
/* {[̒ǉ
 * [  ] volname		: {[
 *			img_hn		: I[vς݃{[̃nhit@Cnhj
 *			volprm		: {[p[^isvȂNULLj
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 * (a) {["ROFS"̓Cu\Ȃ̂ŎgpsB
 * (b) volprm ̕svȃp[^ 0 ɂĂƁB
 */
/* Addition of volume (Expansion)
 * [Inputs ] volname	: volume name
 *			 img_hn		: Opend Volume handle (file handle)
 *			 volprm		: Volume parameter
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 * (a) Volume name "ROFS" is library reservation, it cannot be used.
 * (b) Please set the unnecessary parameter of volprm to 0.
 */
RofsErr CRIAPI		ROFS_AddVolume(Char8 *volname, void *img_hn, RofsVolumePrm *volprm);

/* {[̍폜
 * [  ] volname		: {[
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 */
/* Deletion of volume
 * [Inputs ] volname	: volume name
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 * (a)
 */
RofsErr CRIAPI		ROFS_DelVolume(Char8 *volname);

/* ftHg{[̐ݒ
 * [  ] volname		: {[
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 */
/* Setup of default volume
 * [Inputs ] volname	; volume name
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 */
RofsErr CRIAPI		ROFS_SetDefVolume(Char8 *volname);

/* ftHg{[̎擾
 * [  ] Ȃ
 * [o  ] Ȃ
 * [֐l] {[
 * [  l] 
 */
/* Acquisition of the default volume
 * [Inputs ] none
 * [outputs] none
 * [Return ] volume name
 * [Notes  ] 
 */
Char8 * CRIAPI		ROFS_GetDefVolume(void);

/* {[nh̐؂ւ
 * [  ] volname		: {[
 *			img_hn		: I[vς݃{[̃nhit@Cnhj
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 */
/* The change of a volume handle
 * [Inputs ] volname	: volume name
 *			 img_hn		: Opend Volume handle (file handle)
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 */
RofsErr CRIAPI		ROFS_SwitchImgHn(Char8 *volname, void *img_hn);

/*============================================================================
 *      t@C
 *		Handle File
 *===========================================================================*/
/* t@C̃I[v
 * [  ] fname		: t@C
 *			dir_buf		: fBNgR[h
 * [o  ] Ȃ
 * [֐l] ROFSnh
 * [  l] 
 * (a) dir_buf  NULL ̏ꍇ́AJgfBNgR[hQƂB
 */
/* Opening of a file
 * [Inputs ] fname		: File name
 *			 dir_buf	: Directory record
 * [outputs] none
 * [Return ] ROFS handle
 * [Notes  ] 
 * (a) When dir_buf is NULL, a current directory record is referenced.
 */
Rofs CRIAPI		ROFS_Open(Char8 *fname, void *dir_buf);

/* ZN^wɂt@C̃I[v
 * [  ] volname		: {[
 *			stsct		: 擪ZN^ԍ
 *			nsct		: ZN^
 * [o  ] Ȃ
 * [֐l] ROFSnh
 * [  l] 
 */
/* Opening of the file by sector specification
 * [Inputs ] volname	: volume name
 *			 stsct		: Top sector number
 *			 nsct		: The number of sector
 * [outputs] none
 * [Return ] ROFS handle
 * [Notes  ] 
 */
Rofs CRIAPI		ROFS_OpenRange(Char8 *volname, Sint32 stsct, Sint32 nsct);

/* t@C̃N[Y
 * [  ] rofs		: ROFSnh
 * [o  ] Ȃ
 * [֐l] Ȃ
 * [  l] 
 */
/* Closing of a file
 * [Inputs ] rofs		: ROFS handle
 * [outputs] none
 * [Return ] none
 * [Notes  ] 
 */
void CRIAPI		ROFS_Close(Rofs rofs);

/* t@C݈ʒüړ
 * [  ] rofs		: ROFSnh
 *			nsct		: V[NJnʒüړZN^
 *			sk_mode		: V[N[h
 * [o  ] Ȃ
 * [֐l] t@C擪̃ZN^
 * [  l] 
 */
/* Movement of a file present position
 * [Inputs ] rofs		: ROFS handle
 *			 nsct		: The number of move sectors from a seeking start position
 *			 sk_mode	: Mode of seek
 * [outputs] none
 * [Return ] The number of sectors from a file top
 * [Notes  ] 
 */
Sint32 CRIAPI		ROFS_Seek(Rofs rofs, Sint32 nsct, RofsSeek sk_mode);

/* t@C݈ʒu̎擾
 * [  ] rofs		: ROFSnh
 * [o  ] Ȃ
 * [֐l] t@C擪̃ZN^
 * [  l] 
 */
/* Acquisition of the file present position
 * [Inputs ] rofs		: ROFS handle
 * [outputs] none
 * [Return ] The number of sectors from a file top
 * [Notes  ] 
 */
Sint32 CRIAPI		ROFS_Tell(Rofs rofs);

/* ǂݍ݂̗v
 * [  ] rofs		: ROFSnh
 *			nsct		: ZN^
 * [o  ] buf			: ǂݍݐobt@
 * [֐l] v󂯕tZN^
 * [  l] 
 * (a) buf ̐擪^[Qbgw肷鋫EɑĂƁB
 */
/* Request of reading
 * [Inputs ] rofs		: ROFS handle
 *			 nsct		: The number of sectors
 * [outputs] buf		: Reading buffer
 * [Return ] The number of sectors which received the request
 * [Notes  ] 
 * (a) Must be keep the boundary where a target specifies the address of buf
 */
Sint32 CRIAPI		ROFS_ReqRd(Rofs rofs, Sint32 nsct, void *buf);

/* ]̒~
 * [  ] rofs		: ROFSnh
 * [o  ] Ȃ
 * [֐l] Ȃ
 * [  l]
 */
/* Stop of transfer
 * [Inputs ] rofs		: ROFS handle
 * [outputs] none
 * [Return ] none
 * [Notes  ] 
 */
void CRIAPI		ROFS_StopTr(Rofs rofs);

/* T[o̎s
 * [  ] Ȃ
 * [o  ] Ȃ
 * [֐l] Ȃ
 * [  l] 
 * (a) ADXADXF_SetupRofs֐gĂꍇ́A{֐gȂƁB
 *	   ݂ADXƂ̕pK{BP̂ł͓삵Ȃ̂ŁA{֐͎gȂB
 */
/* Execution of server
 * [Inputs ] none
 * [outputs] none
 * [Return ] none
 * [Notes  ] 
 * (a) Don't use this function when use the ADXF_SetupRofs function 
 *     of ADX is being used.
 *     * present : indispensable alone. Combined use with ADX.
 *                 Don't use this function.
 */
void CRIAPI		ROFS_ExecServer(void);

/*============================================================================
 *      ̎擾
 *		Get Information
 *===========================================================================*/
/* t@CnhԂ̎擾
 * [  ] rofs		: ROFSnh
 * [o  ] Ȃ
 * [֐l] t@CnhXe[^X
 * [  l] 
 */
/* Acquisition of the file handle status
 * [Inputs ] rofs		: ROFS handle
 * [outputs] none
 * [Return ] file handle status
 * [Notes  ] 
 */
RofsStat CRIAPI	ROFS_GetStat(Rofs rofs);

/* t@CTCY̎擾
 * [  ] fname		: t@C
 * [o  ] Ȃ
 * [֐l] t@CTCYioCgj
 * [  l] 
 * (a) l̏ꍇ̓TCYł͖AG[B
 * (b) t@CTCY2GBȏ̏ꍇ 0x7fffffff ԂB
 */
/* Acquisition of the file size
 * [Inputs ] fname		: file name
 * [outputs] none
 * [Return ] file size (byte)
 * [Notes  ] 
 * (a) Return value is error code when return value is minus.
 * (b) Return value is 0x7fffffff when file size is over the 2GB.
 */
Sint32 CRIAPI		ROFS_GetFileSiz(Char8 *fname);

/* t@CTCY̎擾ifBNgR[hwj
 * [  ] fname		: t@C
 *			dir_buf		: fBNgR[h
 * [o  ] Ȃ
 * [֐l] t@CTCYioCgj
 * [  l] 
 * (a) l̏ꍇ̓TCYł͖AG[B
 * (b) t@CTCY2GBȏ̏ꍇ 0x7fffffff ԂB
 */
/* Acquisition of the file size
 * [Inputs ] fname		: file name
 *			 dir_buf	: directory record
 * [outputs] none
 * [Return ] file size (byte)
 * [Notes  ] 
 * (a) Return value is error code when return value is minus.
 * (b) Return value is 0x7fffffff when file size is over the 2GB.
 */
Sint32 CRIAPI		ROFS_GetFileSizEx(Char8 *fname, void *dir_buf);

/* ZN^̎擾
 * [  ] Ȃ
 * [o  ] Ȃ
 * [֐l] ZN^ioCgj
 * [  l] 
 */
/* Acquisition of the sector length
 * [Inputs ] none
 * [outputs] none
 * [Return ] sector length (byte)
 * [Notes  ] 
 */
Sint32 CRIAPI		ROFS_GetSctLen(void);

/* ]ς݃TCY̎擾
 * [  ] rofs		: ROFSnh
 * [o  ] Ȃ
 * [֐l] ]ς݃f[^TCYioCgj
 * [  l] 
 */
/* Acquisition of the transferred data size
 * [Inputs ] rofs		: ROFS handle
 * [outputs] none
 * [Return ] transferred date size (byte)
 * [Notes  ] 
 */
Sint32 CRIAPI		ROFS_GetNumTr(Rofs rofs);

/* {[̎擾
 * [  ] volname		: {[
 * [o  ] volinf		: {[
 * [֐l] G[
 * [  l] 
 */
/* Acquisition of the valume information
 * [Inputs ] volname	: volume name
 * [outputs] volinf		: Volume information
 * [Return ] error code
 * [Notes  ] 
 */
RofsErr CRIAPI		ROFS_GetVolumeInf(Char8 *volname, RofsVolumeInf *volinf);

/*============================================================================
 *      fBNg
 *		Handle Directory
 *===========================================================================*/
/* fBNgR[h̓ǂݍ
 * [  ] dirname		: fBNg
 *			n_dirent	: R[h̏
 * [o  ] dir_buf		: fBNgR[h
 * [֐l] G[
 * [  l] 
 * (a) AB
 * (b) n_dirent ۂ̃R[h̏ꍇ́AROFS_ERR_DIROVER ԂB
 */
/* Reading of a directory record
 * [Inputs ] dirname	: directory name
 *			 n_dirent	: The maximum of the number of records
 * [outputs] dir_buf	: directory record
 * [Return ] error code
 * [Notes  ] 
 * (a) This function is not return, while the function is processing.
 * (b) Return value is ROFS_ERR_DIROVER when n_dirent is under the 
 *     actual number of directory records. */
RofsErr CRIAPI		ROFS_LoadDir(Char8 *dirname, void *dir_buf, Sint32 n_dirent);

/* JgfBNg̐ݒ
 * [  ] volname		: {[
 *			dir_buf		: fBNgR[h
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 */
/* Setup of a current directory
 * [Inputs ] volname	: volume name
 *			 dir_buf	: directory record
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 */
RofsErr CRIAPI		ROFS_SetDir(Char8 *volname, void *dir_buf);

/* JgfBNg̐ݒ(ISO9660fBNgR[h) 
 * [  ] volname		: {[
 *			dir_buf		: fBNgR[h
 *			nsct		: fBNgR[h̃ZN^
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 * (a) TvvOQ
 */
/* Setup of a current directory (Directory record of the ISO9660 image)
 * [Inputs ] volname	: volume name
 *			 dir_buf	: directory record
 *			 nsct		: the number of sectores of directory record
 * [outputs] 
 * [Return ] error code
 * [Notes  ] 
 * (a) refer to sample program.
 */
RofsErr CRIAPI		ROFS_SetIsoDir(Char8 *volname, void *dir_buf, Sint32 nsct);

/* JgfBNg̕ύX
 * [  ] dirname		: fBNg
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 * (a) AB
 * (b) n_dirent ۂ̃R[h̏ꍇ́AROFS_ERR_DIROVER ԂB
 */
/* Changeing of a current directory
 * [Inputs ] dirname	: directory name
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 * (a) This function is not return, while the function is processing.
 * (b) Return value is ROFS_ERR_DIROVER when n_dirent is under the 
 *     actual number of directory records.
 */
RofsErr CRIAPI		ROFS_ChangeDir(Char8 *dirname);

/* t@C݂̔
 * [  ] fname		: t@C
 * [o  ] Ȃ
 * [֐l] LiTRUE = L , FALSE = j
 * [  l] 
 */
/* Judgment of file existence
 * [Inputs ] fname		: file name
 * [outputs] none
 * [Return ] TRUE = exist, FALSE = not exist
 * [Notes  ] 
 */
Bool CRIAPI		ROFS_IsExistFile(Char8 *fname);

/* t@C̎擾
 * [  ] volname		: {[
 * [o  ] Ȃ
 * [֐l] t@Ci"."".."fBNg̐܂ށj
 * [  l] 
 */
/* Acquisition of the number of files
 * [Inputs ] volname	: volume name
 * [outputs] none
 * [Return ] the number of files 
 *           (the number of the directories except "." and ".." is included)
 * [Notes  ] 
 */
Sint32 CRIAPI		ROFS_GetNumFiles(Char8 *volname);

/* fBNg̎擾
 * [  ] volname		: {[
 *			num			: R[h̏
 * [o  ] flist		: t@CiR[h̔zj
 * [֐l] R[h
 * [  l] 
 */
/* Acquisition of the directory information
 * [Inputs ] voname		: volume name
 *			 num		: The maximum of the number of records
 * [outputs] flist		: file information (array of the number of records)
 * [Return ] the number of records
 * [Notes  ] 
 */
Sint32 CRIAPI		ROFS_GetDirInf(Char8 *volname, RofsFileInf *flist, Sint32 num);

/*============================================================================
 *      XNu
 *		Scramble
 *===========================================================================*/
/* XNu̎擾
 * [  ] fname		: t@Ci̓fBNgj
 * [o  ] scrinf		: XNu
 * [֐l] G[
 * [  l] 
 * (a) TvvOQ
 */
/* Acquisition of the scramble information
 * [Inputs ] fname		: file name (or directory name)
 * [outputs] scrinf		: scramble information
 * [Return ] error code
 * [Notes  ] 
 * (a) refer to sample program.
 */
RofsErr CRIAPI		ROFS_GetScrambleInf(Char8 *fname, RofsScrambleInf *scrinf);

/* XNủ
 * [  ] buf			: XNuf[^obt@
 *			sctnum		: ZN^
 *			scrinf		: XNu
 * [o  ] scrinf		: XNuiXVj
 * [֐l] G[
 * [  l] 
 * (a) scrinf ̓e͍XVB
 * (b) TvvOQ
 */
/* Descramble
 * [Inputs ] buf		: scrambled data
 *			 sctnum		: buffer size (the number of sector)
 *			 scrinf		: scramble information
 * [outputs] scrinf		: scramble information (after update)
 * [Return ] error code
 * [Notes  ] 
 * (a) The contents of scrinf are updated.
 * (b) refer to sample program.
 */
RofsErr CRIAPI		ROFS_Descramble(void *buf, Sint32 sctnum, RofsScrambleInf *scrinf);

/*============================================================================
 *      G[
 *		Handle Error
 *===========================================================================*/
/* G[R[obN֐̓o^
 * [  ] errfunc		: G[R[obN֐
 *			obj			: G[IuWFNg
 * [o  ] Ȃ
 * [֐l] Ȃ
 * [  l] 
 */
/* Registration of an error callback function
 * [Inputs ] errfunc	: error callack function
 *			 obj		: error object
 * [outputs] none
 * [Return ] noghing
 * [Notes  ] 
 */
void CRIAPI		ROFS_EntryErrFunc(RofsErrFunc errfunc, void *obj);

/* ŌɔG[擾
 * [  ] Ȃ
 * [o  ] Ȃ
 * [֐l] G[
 * [  l] 
 */
/* Acquisition of the last error code
 * [Inputs ] none
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 */
RofsErr CRIAPI		ROFS_GetLastError(void);

/*============================================================================
 *      64bitΉ
 *		64bit Operation
 *===========================================================================*/
/* ]ς݃TCY̎擾 / 64bit / PS2
 * [  ] rofs		: ROFSnh
 * [o  ] Ȃ
 * [֐l] ]ς݃f[^TCYioCgj
 * [  l] 
 */
/* Acquisition of the transferred data size / 64bit / for PS2
 * [Inputs ] rofs		: ROFS handle
 * [outputs] none
 * [Return ] transferred date size (byte)
 * [Notes  ] 
 */
Sint64 CRIAPI		ROFS_GetNumTr64(Rofs rofs);

/* t@CTCY̎擾 / 64bit / PS2
 * [  ] fname		: t@C
 * [o  ] Ȃ
 * [֐l] t@CTCYioCgj
 * (a) l̏ꍇ̓TCYł͖AG[B
 * (b) t@CTCY2GBȏ̏ꍇ 0x7fffffffffffffff ԂB
 */
/* Acquisition of the file size / 64bit / for PS2
 * [Inputs ] fname		: file name
 * [outputs] none
 * [Return ] file size (byte)
 * [Notes  ] 
 * (a) Return value is error code when return value is minus.
 * (b) Return value is 0x7fffffff when file size is over the 2GB.
 */
Sint64 CRIAPI		ROFS_GetFileSiz64(Char8 *fname);

/* t@CTCY̎擾ifBNgR[hwj / 64bit / PS2
 * [  ] fname		: t@C
 *			dir_buf		: fBNgR[h
 * [o  ] Ȃ
 * [֐l] t@CTCYioCgj
 * [  l] 
 * (a) l̏ꍇ̓TCYł͖AG[B
 * (b) t@CTCY2GBȏ̏ꍇ 0x7fffffff ԂB
 */
/* Acquisition of the file size
 * [Inputs ] fname		: file name
 *			 dir_buf	: directory record
 * [outputs] none
 * [Return ] file size (byte)
 * [Notes  ] 
 * (a) Return value is error code when return value is minus.
 * (b) Return value is 0x7fffffff when file size is over the 2GB.
 */
Sint64 CRIAPI		ROFS_GetFileSizEx64(Char8 *fname, void *dir_buf);

/*============================================================================
 *      fBNgR[ht@C֘A
 *		For directory recored file
 *===========================================================================*/
/* fBNgR[ht@CCVM̐`FbN
 * [  ] vol		: {[
 *			cvmtim	: CVMt@C̃^CX^vf[^ir_o͂j
 * [o  ] Ȃ
 * [֐l] G[
 * [  l]
 * fBNgR[ht@ĆAۂɎgCVM쐬ȂĂ͂ȂȂB
 * {֐ŕsNĂȂ`FbNłB
 * ȉ̏ꍇɃG[ԂB
 * (a) {[ԈĂBi. o^{[j
 * (b) fBNgXg݂CVMt@Cꂽ̂ł͂ȂB
 */
/* Check validness of the directory list
 * [Inputs ] vol	: Volume name
 *			 cvmtim	: Time stamp of CVM file (Output by ROFSBLD)
 * [outputs] none
 * [Return ] error code
 * [Notes  ]
 * You have to create a directory record file from actually used CVM.
 * It can be confirmed whether mismatching has occurred with this function.
 * Error code is returned in the following cases.
 * (a) When the volume name is wrong. (EX. non registerd volume)
 * (b) When the directory list is not created from current CVM file.
 */
RofsErr CRIAPI	ROFS_CheckDirrecFile(Char8 *volname, void *cvmtim);

/*============================================================================
 *      ̑
 *		Other
 *===========================================================================*/
/* o[W̎擾
 * [  ] Ȃ
 * [o  ] Ȃ
 * [֐l] o[W̃|C^
 * [  l]
 */
/* Acquisition of the version string
 * [Inputs ] none
 * [outputs] none
 * [Return ] version string
 * [Notes  ] 
 */
const Char8	* CRIAPI	ROFS_GetVersionStr(void);

/* f[^ǂݍݑ҂^CAEg̐ݒ
 * [  ] sec		: ^CAEg܂ł̎ԁibj
 * [o  ] Ȃ
 * [֐l] Ȃ
 * [  l]
 * (a) f[^ǂݍݎAsec Őݒ肵Ԃo߂Ăf[^
 *     ǂݍ܂ȂꍇAROFS_ERR_TOUT B
 * (b) {֐Őݒ肵҂Ԃ́A{[̓o^fBNg
 *     ̓ǂݍ݂ȂǁAA̓ǂݍ݂̏ꍇɓKpB
 * (c) ftHgł͖Tbɐݒ肳ĂB
 */
/* Setup of the waiting timeout for data reading
 * [Inputs ] sec	: Time until it carries out a timeout (second)
 * [outputs] none
 * [Return ] none
 * [Notes  ] 
 * (a) At the time of data reading, even if the time set up by sec passes,
 *     when data is not read, ROFS_ERR_TOUT occurs. 
 * (b) In readings of a completion return, such as registration of volume,
 *     and a directory, the waiting time set up with this function is applied.
 * (c) Default is about 5 seconds.
 */
void CRIAPI		ROFS_SetTimeoutTime(Uint32 sec);

/* ̐ݒ 
 * [  ] rofs		: ROFSnhiNULL = Śj
 *			condid		: ID
 *			val			: ݒl
 * [o  ] Ȃ
 * [֐l] G[
 * [  l]
 */
/* Set operating condition
 * [Inputs ] rofs		: ROFS handle
 *			 condid		: operating condition id
 *			 val		: parameter
 * [outputs] none
 * [Return ] error code
 * [Notes  ] 
 */
RofsErr CRIAPI	ROFS_SetCond(Rofs rofs, RofsCondId condid, Sint32 val);

/* ̎擾
 * [  ] rofs		: ROFSnhiNULL = Śj
 *			condid		: ID
 * [o  ] val			: ݒl
 * [֐l] G[
 * [  l]
 */
/* Get operating condition
 * [Inputs ] rofs		: ROFS handle
 *			 condid		: operating condition id
 * [outputs] val		: parameter
 * [Return ] error code
 * [Notes  ] 
 */
RofsErr CRIAPI	ROFS_GetCond(Rofs rofs, RofsCondId condid, Sint32 *val);




#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _CRI_ROFS_H_ */

/*****************************************************************************
 *      Zp
 *		Technical information
 *****************************************************************************/
#if 0
(1) fBNgR[h[h
  @ʏ{CuCVMt@CfBNgR[h擾܂B
  fBNgR[h[h ROFS_PARM_DIRSRC_MEM ɐݒ肷邱ƂŁA
  OɎƂ\łB
  @̃[hł̓CuƗ̈AddVolumeLoadDir̃I[owbh
  炷Ƃł܂B

  ݒ@j
    err = ROFS_SetCond(NULL, ROFS_COND_DIRSRC, ROFS_PARM_DIRSRC_MEM);

  ӎj
  (a) ̃[hgɂ́A炩ROFSBLDŃfBNgR[ht@C
      o͂ĂKvB
  (b) ROFS_Init֐̈ARofsInitPara\̂max_dirento͍ŒRKvB
  (c) ROFS_Init֐̒ɐݒ肷邱ƁB
      邱ƂŁAROFS_AddVolume֐sɃ[gfBNg̓ǂݍ
      Ȃ̂Ń}EgȂB
  (d) ̃[hł͈ȉ̊֐gĂ͂ȂȂB
      ROFS_ChangeDir
  (e) ̃[hɂ͖߂ȂB

/*---------------------------------------------------------------------------*/

(1) Directory record mode
  Usualy this liblary get directory records fom CVM file.
  Supported that change directory with directory record file which is 
  created by rofsbld.exe.
  When AddVolume and LoadDir it can save the liblary work memory and 
  reduce process overhead.

  How to)
    err = ROFS_SetCond(NULL, ROFS_COND_DIRSRC, ROFS_PARM_DIRSRC_MEM);

  Note)
  (a) In order to use this mode, it is necessary to output directory lists
      with ROFSBLD beforehand.
  (b) The argument of a ROFS_Init function and the max_dirent member of a 
      RofsInitPara structure object are at least 3 necessities.
  (c) Please call immediately after a ROFS_Init function.
      By carrying out like this, since reading processing of a 
      root directory is lost at the time of ROFS_AddVolume function 
      execution, mount becomes quick.
  (d) Do not use the following functions.
      ROFS_ChangeDir
  (e) It cannot restore the original mode.
#endif

/* end of file */
