/*
Copyright (c) 2006, Intel Corporation.

This Intel Laptop Gaming TDK ("Software") is furnished under license and may 
only be used or copied in accordance with the terms of that license. No license, 
express or implied, by estoppel or otherwise, to any intellectual property rights 
is granted by this document. The Software is subject to change without notice, 
and should not be construed as a commitment by Intel Corporation to market, 
license, sell or support any product or technology. Unless otherwise provided 
for in the license under which this Software is provided, the Software is 
provided AS IS, with no warranties of any kind, express or implied. 
Except as expressly permitted by the Software license, neither Intel Corporation 
nor its suppliers assumes any responsibility or liability for any errors or 
inaccuracies that may appear herein. Except as expressly permitted by the 
Software license, no part of the Software may be reproduced, stored in a 
retrieval system, transmitted in any form, or distributed by any means 
without the express written consent of Intel Corporation.
*/

/**
* This class provides abstract base class 'AbstractEventInfo' which are
* used by all other classes to implement event notification model
*/

#ifndef IGLABSTRACTEVENTINFO_H
#define IGLABSTRACTEVENTINFO_H

#include "ILGNotify.h"

//using namespace std;

class AbstractEventInfo
{
public:
	virtual void Start(int event, Notifiable* m_pNot, int ThresholdValue = 0, int UpdateFreq = 2000) = 0;
	virtual void Stop(int event) = 0;
	virtual ~AbstractEventInfo(){};
	
	// structure to pass to thread functions including this pointer for the class 
	// pointer to call back observer and threshold paramater
	struct ThreadParamStruct
	{
	public:
		AbstractEventInfo* pPtr;
		Notifiable* pNotif;
		int Threshold;
		int UpdateFreq;
	};

};

#endif IGLABSTRACTEVENTINFO_H