/*
Copyright (c) 2006, Intel Corporation.

This Intel Laptop Gaming TDK ("Software") is furnished under license and may 
only be used or copied in accordance with the terms of that license. No license, 
express or implied, by estoppel or otherwise, to any intellectual property rights 
is granted by this document. The Software is subject to change without notice, 
and should not be construed as a commitment by Intel Corporation to market, 
license, sell or support any product or technology. Unless otherwise provided 
for in the license under which this Software is provided, the Software is 
provided AS IS, with no warranties of any kind, express or implied. 
Except as expressly permitted by the Software license, neither Intel Corporation 
nor its suppliers assumes any responsibility or liability for any errors or 
inaccuracies that may appear herein. Except as expressly permitted by the 
Software license, no part of the Software may be reproduced, stored in a 
retrieval system, transmitted in any form, or distributed by any means 
without the express written consent of Intel Corporation.
*/

/**
* This class defines BandwidthInfo methods which provide access to current transmit, receive
* and total bytes over active network connection.
* Also provides events for getting current bandwith info in bytes per sec using polling
*/
#ifndef ILGBANDWIDTHINFO_H
#define ILGBANDWIDTHINFO_H

#define _WIN32_DCOM

#include <Wbemidl.h>
#include <atlstr.h>
#include "ILGAbstractEventInfo.h"
#include "ILGdefines.h"

// Warning here complains about using non-dll base class for creating PowerInfo
#pragma warning( disable : 4275 )

typedef unsigned (WINAPI *PBEGINTHREADEX_THREADFUNC)(LPVOID lParam);
typedef unsigned *PBEGINTHREADEX_THAREDID;

class BandwidthInfo : public AbstractEventInfo
{

public:
	//static BandwidthInfo* GetBandwidthInfoObj();
	BandwidthInfo();
	~BandwidthInfo();

	/**
	* Returns current transmit rate in bytes per sec
	*/
	unsigned long GetCurrentTxRate();

	/**
	* Returns current receive rate in bytes per sec
	*/
	unsigned long GetCurrentRxRate();

	/**
	* Returns total receive + transmit rate in bytes per sec
	*/
	unsigned long GetTotalTxRxRate();

	/**
	* This method prompts polling methods to get access to current
	* bandwidth rates in bytes/sec. This keeps running until Stop()
	* is called
	*/
	void Start(int event, Notifiable* m_pNot, int ThresholdValue = 0, int UpdateFreq = 2000);

	/**
	* This method stops any active events, created with Start() method
	*/
	void Stop(int event);

private:
	/**
	* Private function to get transmit, receive, total rate based on
	* parameter being passed
	*/
	unsigned long GetRate(int selection);
	HRESULT hr;
    
    long lID;
	// Handle for transmit bytes
	long m_lSentBytesHandle;
	// Handle for receive bytes
	long m_lRecvdBytesHandle;
	// Transmitted bytes
	unsigned long m_dwSentBytes;
	// Received bytes
	unsigned long m_dwRecvdBytes;
    unsigned long m_dwNumObjects;
    unsigned long m_dwNumReturned;
    unsigned long m_i;
	// bools to track first check to get number of adapters 
	// and to track successful initialization
	bool bFirstCheck;
	static bool bInitialize;
	static bool bOrigCOMUsed;
	// variable to return failure
	const unsigned long FUNCTIONFAILED;

	// parameters for two threads. Defined in base file
	// structure to pass to thread functions including this pointer for the class 
	// pointer to call back observer and threshold paramater.
	ThreadParamStruct pStruct[3];

	// Thread function for monitoring TxRate
	static DWORD WINAPI ThreadFuncTxRate(LPVOID ThreadParam);

	// non-static function that the thread function calls to detect TxRate
	void ThreadMonitorTxRate(Notifiable* pNotif, int frequency);

	// Thread function for monitoring RxRate
	static DWORD WINAPI ThreadFuncRxRate(LPVOID ThreadParam);

	// non-static function that the thread function calls to detect RxRate
	void ThreadMonitorRxRate(Notifiable* pNotif, int frequency);

	// Thread function for monitoring TotalRate
	static DWORD WINAPI ThreadFuncTotalRate(LPVOID ThreadParam);

	// non-static function that the thread function calls to detect TotalRate
	void ThreadMonitorTotalRate(Notifiable* pNotif, int frequency);

	// Thread handle
	HANDLE h[3];

	// Bool variable to control monitoring of power state
	bool bMonitorTx, bMonitorRx, bMonitorTotal;

	// Bool variables to check if the threads are already running
	bool bThread0Running, bThread1Running, bThread2Running, bEndThread0, bEndThread1, bEndThread2;

	CRITICAL_SECTION m_cs;
};

#endif