/*
Copyright (c) 2006, Intel Corporation.

This Intel Laptop Gaming TDK ("Software") is furnished under license and may 
only be used or copied in accordance with the terms of that license. No license, 
express or implied, by estoppel or otherwise, to any intellectual property rights 
is granted by this document. The Software is subject to change without notice, 
and should not be construed as a commitment by Intel Corporation to market, 
license, sell or support any product or technology. Unless otherwise provided 
for in the license under which this Software is provided, the Software is 
provided AS IS, with no warranties of any kind, express or implied. 
Except as expressly permitted by the Software license, neither Intel Corporation 
nor its suppliers assumes any responsibility or liability for any errors or 
inaccuracies that may appear herein. Except as expressly permitted by the 
Software license, no part of the Software may be reproduced, stored in a 
retrieval system, transmitted in any form, or distributed by any means 
without the express written consent of Intel Corporation.
*/

/***=========================================================================
* Based on GammaManager project published on CodeProject site
*    Creation date       :  24/10/2002                                
*    Author(s)           :  Dany Cantin                               
*                  Copyright  DCUtility  2002                        
===========================================================================*/

/**
* This class provides methods to access various properties in the Display sub-system
* resource. This class provides access to methods like current resolution, depth 
* buffer, brightness (based on gamma value only). get/set methods are provided for 
* each of the properties.
*/
#ifndef ILGDISPLAYINFO_H
#define ILGDISPLAYINFO_H

#include <math.h>
#include "ILGdefines.h"

#define SEVEN_SIXTY_EIGHT	768

class DisplayInfo
{

public:
	DisplayInfo();	
	~DisplayInfo();

	/**
	* Get Display resolution
	*/
	Resolution GetDisplayResolution();

	/**
	* Set display resolution e.g. 1024x768
	*/
	bool SetDisplayResolution(Resolution res);

	/**
	* Get display color depth
	*/
	int GetDisplayColorDepth();
	
	/**
	* Set color depth for display properties
	*/
	bool SetDisplayColorDepth(int depth);

	/**
	* Get display screen brightness
	*/
	float GetDisplayScreenBrightness();

	/**
	* Set display screen brightness
	*/
	bool SetDisplayScreenBrightness(float brightness);

	/**
	* Restore the original screen brightness if needed by an app.
	*/
	bool RestoreOriginalBrightness();

private:
	
	// consts used for computations
	const int MAX_POS;
	const float POS_FACTOR;
	const double MAX_DOUBLE;
	const int SEVENSIXTYEIGHT;
	const double TWOFIFTYSIX;

	// Stores original gamma array
	unsigned short OriginalGamma[768];

	// This function stores original gamma array for later use
	bool GetOriginalGammaArray();

	// critical section for protecting shared varible
	CRITICAL_SECTION m_cs;
	
};

#endif ILGDISPLAYINFO_H