/*
Copyright (c) 2006, Intel Corporation.

This Intel Laptop Gaming TDK ("Software") is furnished under license and may 
only be used or copied in accordance with the terms of that license. No license, 
express or implied, by estoppel or otherwise, to any intellectual property rights 
is granted by this document. The Software is subject to change without notice, 
and should not be construed as a commitment by Intel Corporation to market, 
license, sell or support any product or technology. Unless otherwise provided 
for in the license under which this Software is provided, the Software is 
provided AS IS, with no warranties of any kind, express or implied. 
Except as expressly permitted by the Software license, neither Intel Corporation 
nor its suppliers assumes any responsibility or liability for any errors or 
inaccuracies that may appear herein. Except as expressly permitted by the 
Software license, no part of the Software may be reproduced, stored in a 
retrieval system, transmitted in any form, or distributed by any means 
without the express written consent of Intel Corporation.
*/

/**
* This file lists all event ID, enums and structs used by each classes
*/

#ifndef DEFINES_H
#define DEFINES_H


enum PowerScheme
{
	Throttle_None,
	Throttle_Constant,
	Throttle_Degrade,
	Throttle_Adaptive,
	Throttle_Undefined = 255
};

enum PowerSource
{
	Battery_Power,
	AC_Power,
	Undefined = 255
};

#define LOW_BATTERY_REACHED			0
#define POWER_SRC_CHANGED			1
#define BATTERY_LIFE_PRCNT_CHANGED	2
#define WIRELESS_SIGNAL_STRENGTH	3
#define CONNECTIVITY_STATUS			4
#define CURRENT_CPU_UTIL			5
#define CURRENT_CPU_FREQ			6
#define CURRENT_TX_RATE				7
#define CURRENT_RX_RATE				8
#define CURRENT_TOTAL_BW			9

#define DISCONNECTED	0
#define CONNECTED		1

struct Resolution
{
	int HorizRes;
	int VerRes;
};

// Error codes
#define FUNCTION_FAILED	-1
#define INVALID_INPUT	-2

#endif DEFINES_H