/*
Copyright (c) 2006, Intel Corporation.

This Intel Laptop Gaming TDK ("Software") is furnished under license and may 
only be used or copied in accordance with the terms of that license. No license, 
express or implied, by estoppel or otherwise, to any intellectual property rights 
is granted by this document. The Software is subject to change without notice, 
and should not be construed as a commitment by Intel Corporation to market, 
license, sell or support any product or technology. Unless otherwise provided 
for in the license under which this Software is provided, the Software is 
provided AS IS, with no warranties of any kind, express or implied. 
Except as expressly permitted by the Software license, neither Intel Corporation 
nor its suppliers assumes any responsibility or liability for any errors or 
inaccuracies that may appear herein. Except as expressly permitted by the 
Software license, no part of the Software may be reproduced, stored in a 
retrieval system, transmitted in any form, or distributed by any means 
without the express written consent of Intel Corporation.
*/

/**
* This is a higher level class which provides access to classes defined 
* for individual devices. This class is exposed to user and control 
* creation and deletion of objects as needed
*/

#ifndef INTELGAMINGTDKAPI_H
#define INTELGAMINGTDKAPI_H

#include "ILGdefines.h"
#include "ILGAbstractEventInfo.h"

class PowerInfo;
class ProcessorInfo;
class NetworkInfo;
class DisplayInfo;
class BandwidthInfo;

class _declspec(dllexport) IntelLaptopGamingTDKInterface
{
private:
	PowerInfo* m_PowerInfo;
	NetworkInfo* m_NetworkInfo;
	DisplayInfo* m_DisplayInfo;
	ProcessorInfo* m_ProcessorInfo;
	BandwidthInfo* m_BandwidthInfo;
	static bool bInitialize;
protected:
	IntelLaptopGamingTDKInterface();
	static IntelLaptopGamingTDKInterface* Interface;
	
public:

	/**
	* Static function to get instance of pointer to IntelLaptopGamingTDKInterface 
	* class
	*/
	static IntelLaptopGamingTDKInterface* GetTDKInterface();

	/**
	* Standard destructor
	*/
	~IntelLaptopGamingTDKInterface();

	// Properties

	/**
	* Start the threaded model offered by the TDK to get updates to
	* specified events/properties. 
	* This function takes in pointer to 'Notifiable' class implemented
	* by the client to call back into caller site.
	*/
	void RegisterEventObserver(int event, Notifiable* m_pNot, int WatchForValue = -1, int UpdateFreq = 2000);

	/**
	* Halt the threaded model offered by the TDK. 
	*/
	void UnregisterEventObserver(int event);


	/**
	* Checks if the current system is a laptop
	*/
	bool IsLaptop();

	/**
	* Get current power source
	*/
	PowerSource GetPowerSrc();

	/**
	* Get percent battery life left
	*/
	int GetPercentBatteryLife();

	/**
	* Get battery life time remaining
	*/
	unsigned long GetSecBatteryLifeTimeRemaining();

	/**
	* Get current power scheme of the system
	*/
	PowerScheme GetCurrentPowerScheme();

	/**
	* Set power scheme for the system
	*/
	bool SetCurrentPowerScheme(PowerScheme new_scheme);


	/**
	* Get 802.11 signal strength
	*/
	int Get80211SignalStrength();

	/**
	* Is wireless adapter connected to network
	*/
	bool IsWirelessAdapterConnected();

	/**
	* Is wireless adapter enabled
	*/
	bool IsWirelessAdapterEnabled();

	/**
	* Get list of all adapters on the system
	*/
	char** GetAllNetworkAdapters(int* cnt);

	/**
	* Get IP address
	*/
	char** GetIPAddresses(int* cnt);

	/**
	*
	*/
	unsigned char* GetConnectedAdapter();


	/**
	* Get current Tx Rate in bytes/sec 
	*/
	unsigned long GetCurrentTxRate();

	/**
	* Get current Rx Rate in bytes/sec
	*/
	unsigned long GetCurrentRxRate();

	/**
	* Get Tx + Rx rate in bytes/sec
	*/
	unsigned long GetTotalTxRxRate();

	
	/**
	* Get current dislay resolution. Returned as struct
	*/
	Resolution GetDisplayResolution();

	/**
	* Set display resolution e.g. 1024x768
	*/
	bool SetDisplayResolution(Resolution res);
	
	/**
	* Set color depth for display properties
	*/
	bool SetDisplayColorDepth(int depth);

	/**
	* Set display screen brightness
	*/
	bool SetDisplayScreenBrightness(float brightness);

	/**
	* Get display color depth
	*/
	int GetDisplayColorDepth();

	/**
	* Get display screen brightness
	*/
	float GetDisplayScreenBrightness();

	/**
	* Restore original screen brightness
	*/
	bool RestoreOriginalBrightness();


	/**
	* Get number of core on per physical processor
	*/
	unsigned int GetNumCoresPerProcessor();

	/**
	* Get total number of processors as seen by OS
	*/
	unsigned int GetNumProcessors();
	
	/**
	* Get number of active threads for a process
	*/
	int GetNumActiveThreadsForProcess(const char* ProcessName);

	/**
	* Get current CPU utilization
	*/
	int GetCurrentCPUUtilization(int CpuNum = -1);

	/**
	* Get current processor frequency
	*/
	unsigned long GetCurrentCPUFrequency();

	/**
	* Get maximum frequency
	*/
	unsigned long GetMaxCPUFrequency();
};

#endif INTELGAMINGTDKAPI_H