var g_sEvent = "Post_CheckIn";

// Which Sever will be used for sending mails
var MailServer= "mail2.INTERN.CRYTEK.DE";

function Execute_Post_CheckIn()
{
	// get current object
	var oCurrent = NxNNamespace.CurrentObject; 
	
	// get the selection from Alienbrain  
	var oSelection = NxNNamespace.Selection;
	var nLength = oSelection.length;
	
	var Sender = "";	
	var NoComment = false;
	var aPaths = new Array;	
	var AddedToSelection = false;
	
	// get the path of the current object
	var sCurrentPath = oCurrent.GetProperty( "NamespacePath", false, false );
	
	// get the Projectname
	var Project = sCurrentPath.slice(sCurrentPath.indexOf("\\","5")+1,sCurrentPath.indexOf("\\","13"));
	
	// If no selection is given (e.g. from a integration) add currentobject to selection
	if( nLength == 0 )
	{
		AddedToSelection = true;
		NxNNamespace.AddSelection( sCurrentPath );
		oSelection = NxNNamespace.Selection;
		nLength = oSelection.length;
	}
	
	// get the path of the last object in selection
	var oLastItem = oSelection.Item( nLength-1 );
	var sLastPath = oLastItem.GetProperty( "NamespacePath", false, false );

	// we only want to email the paths once, so match the last path and only mail if project is game02 or game04
	if ( sCurrentPath == sLastPath  && (Project == "Game02" || Project == "Game04"))
	{
		// Create the beginning of body for the email
		var Msg = "Checkin by User " + oCurrent.GetProperty("UserName") + " on " + tSYS_GetTime()  +"\n\nAffected files:\n" ;
		// iterate through selection to get paths
		for ( var i=0; i<nLength; i++ )
		{
		  var oItem = oSelection.Item( i );
		  // Get the comment if a object is a file
		  if(tNS_IsFile(oItem.GetProperty( "NamespacePath", false, false )))
			{
				var sComment = oItem.GetProperty("CheckInComment")
				if( sComment == "")
				{
					Msg +=  "---No Comment---\n" ;
					NoComment = true;
				}
				else
				{
					Msg +=  "---" + sComment + "---\n" ;
				}
			}
			// the object is a folder, folders do not have comments
			else
			{
				Msg +=  "---Folders can't have a comment---\n" ;
			}
			// Create the list of changed files for the Email
			var temp = oItem.GetProperty( "NamespacePath", false, false );
			temp = temp.slice(temp.indexOf("\\","2"),temp.length);
			Msg +=  "File: " + temp + "\n\n";
		  aPaths.push(oItem.GetProperty( "NamespacePath", false, false ));
		}
	
		//--------------------find modules----------------------------------------------------------------------------
		var modules = "";
		var compare = "";	
	
		//--------------------Split on every slash and compare the found modules--------------------------------------
		for(i=0; i < aPaths.length; i++)
		{
			var splitonsingleslash = aPaths[i].split("\\");
			var length = splitonsingleslash.length - 2;
	
			if( compare.search(splitonsingleslash[length]) == -1)		
			{
				compare += splitonsingleslash[length];
				modules += " " + splitonsingleslash[length];
				modules += ",";
			}
		}
		
		// Delete the "," at the end of subject
		var finalmodules = modules.slice(1,modules.length-1);
		
		// Set the Alienbrain user as sender of email
		Sender = oCurrent.GetProperty("UserName") + "@Crytek.de"
		
		// Notify somebody if he forgot a comment
		if(NoComment)
		{
			var To = oCurrent.GetProperty("UserName") + "@Crytek.de";
			SendMail( To ,Msg,"No comment on one or more files!",Sender,1 );
		}

		if(Project == "Game02")
		{
			var To = "FP_ALIENBRAIN@crytek.de"
		}
		else if(Project == "Game04")
		{
			var To = "G4_ALIENBRAIN@crytek.de"
		}
		
		// Create the subject of the mail
		var MailSubject = "Changed Modules: "+finalmodules;
		if(NoComment)
		{
			MailSubject += " !No comment on one or more files!";
		}
		
		// Send the mail out
		SendMail( To ,Msg,MailSubject,Sender,1 );
	}	
	
	if(AddedToSelection)
	{
		NxNNamespace.ClearSelection();
	}		
}


//+++++++++++++++++++++++++Mainfunction for sending mails+++++++++++++++++++++++++
function SendMail( recipient,msg,subject,SenderEmail,importance )
{

	var cdoConfig = new ActiveXObject("CDO.Configuration");
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2; //cdoSendUsingPort
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1; //cdoBasic
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserver") = MailServer;
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = 25;
	cdoConfig.Fields.Update();

	var cdoMessage = new ActiveXObject( "CDO.Message" );
	cdoMessage.Configuration = cdoConfig;

	cdoMessage.Subject = subject;
	cdoMessage.From = SenderEmail;
	cdoMessage.To = recipient;
	cdoMessage.TextBody = msg;

	cdoMessage.Send();
}

Execute_Post_CheckIn();
