SOURCE = "ag.xml"
DEST = "out.dot"

import sys
import os
from xml.dom.minidom import parse

if len(sys.argv)>1:
	SOURCE = sys.argv[1]

dom = parse(SOURCE)
out = open(DEST, "w")

def fixup(txt):
    out = ""
    for c in txt:
        if c == "+":
            out += "__plus__";
        else:
            out += c;
    return out;

out.write( "digraph G {\n" )
for state in dom.getElementsByTagName("Link"):
	out.write( "%s -> %s\n" % (fixup(state.getAttribute("from")), fixup(state.getAttribute("to"))) )
for state in dom.getElementsByTagName("BiLink"):
	out.write( "%s -> %s [arrowhead=normal, arrowtail=normal]\n" % (fixup(state.getAttribute("from")), fixup(state.getAttribute("to"))) )
for state in dom.getElementsByTagName("State"):
	out.write( "%s\n" % fixup(state.getAttribute("id")) )
out.write( "}\n" )

out = None

os.system("neato -Tjpg -oout.jpg %s" % DEST)
os.system("out.jpg")

