// Sync.h : Declaration of the CSync

#pragma once
#include "resource.h"       // main symbols
#include <set>
#include <list>
#include <string>
#include <windows.h>


typedef std::set<CString> FileMap;
typedef FileMap::iterator FileMapItor;
typedef std::list<std::pair<CString,CString> > ProjectList;
typedef ProjectList::iterator ProjectListItor;

// ISync
[
	object,
	uuid("217EFC0F-D2CF-4BAF-8030-B8EED3CA25AC"),
	dual,	helpstring("ISync Interface"),
	pointer_default(unique)
]
__interface ISync : IDispatch
{
	[id(1), helpstring("method SetWorkingDir")] HRESULT SetWorkingDir([in] BSTR localpath);
	[id(2), helpstring("method AddProject")] HRESULT AddProject(BSTR dbpath, BSTR projpath);
	[id(3), helpstring("method DoIt")] HRESULT DoIt();
	[id(4), helpstring("method AddFileFilter")] HRESULT AddFileFilter(BSTR extension);
};



// CSync

[
	coclass,
	threading("apartment"),
	support_error_info("ISync"),
	vi_progid("AssManX.Sync"),
	progid("AssManX.Sync.1"),
	version(1.0),
	uuid("6137FE56-235E-44BE-8E76-36B356AB1574"),
	helpstring("Sync Class")
]
class ATL_NO_VTABLE CSync : 
	public ISync
{
public:
	CSync()
	{
	}


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}
	
	void FinalRelease() 
	{
	}

public:

	STDMETHOD(SetWorkingDir)(BSTR localpath);
	STDMETHOD(AddProject)(BSTR dbpath, BSTR projpath);
	STDMETHOD(DoIt)();
private:
	void FillFileMap( const CString &sPath );
	void SyncFolders(_bstr_t sDatabase,_bstr_t sProjPath,_bstr_t sLocalDir);
	void SyncItem(IVSSItem *pItem, _bstr_t sFolder);
	bool FilePass( const CString &filename );

	FileMap m_setFileMap;
	ProjectList m_lstProjectList;
	FileMap m_setFilters;
	_bstr_t m_sWorkingFolder;

public:
	STDMETHOD(AddFileFilter)(BSTR extension);
};

