#include "stdafx.h"
#include "Utilities.h"



using namespace std;



bool 
FindFile( const tstring& strFilePath )
{
	bool bRet( false );
#ifdef UNICODE
	FILE* f( _wfopen( strFilePath.c_str(), _T( "rb" ) ) );
#else
	FILE* f( fopen( strFilePath.c_str(), _T( "rb" ) ) );
#endif
	if( 0 != f )
	{
		bRet = true;
		fclose( f );
	}
	return( bRet );
}



tstring 
GetStringFromResource( const HINSTANCE& hInstance, unsigned int uiStringResID )
{
	TCHAR szTmp[ 1024 ];
	szTmp[ 0 ] = 0;
	LoadString( hInstance, uiStringResID, szTmp, sizeof( szTmp ) );	
	return( tstring( szTmp ) );
}



void
GetAccessToResource( const unsigned char*& pucData, unsigned int& uiDataSize, const TCHAR* pcResourceName )
{
	HRSRC  hInfoBlock;
	HANDLE hRes;

	// find the requested resource in our module
	if( 0 == ( hInfoBlock = FindResource( GetModuleHandle( 0 ), pcResourceName, RT_RCDATA ) ) )
	{
		return;
	}

	// get size
	uiDataSize = SizeofResource( 0, hInfoBlock );
	if( 0 == uiDataSize )
	{
		return;
	}

	// load resource
	if( 0 == ( hRes = LoadResource( 0, hInfoBlock ) ) )
	{
		return;
	}

	// get pointer to resource data
	pucData = (unsigned char *) LockResource( hRes );
}
