#ifndef HASH_H
#define HASH_H

#include "fileio.h"
#include "bstream.h"
#include <iostream>

struct IHashProgressCallback
{
	virtual void OnProgress() = 0;
};

class CHash
{
public:
	CHash( CFile&, IHashProgressCallback * pProgress );
	CHash() {}

	friend BOutputStream& operator<<( BOutputStream& out, const CHash& hash )
	{
		memcpy( out.Put(16), hash.m_hash, 16 );
		return out;
	}

	friend BInputStream& operator>>( BInputStream& in, CHash& hash )
	{
		memcpy( hash.m_hash, in.Get(16), 16 );
		return in;
	}

	friend std::ostream& operator<<( std::ostream& out, const CHash& hash )
	{
		for (int i=0; i<16; i++)
			HexByte( out, hash.m_hash[i] );
		return out;
	}

	bool operator==( const CHash& rhs ) const
	{
		return 0 == memcmp(m_hash, rhs.m_hash, 16);
	}

	bool operator!=( const CHash& rhs ) const
	{
		return !operator==(rhs);
	}

private:
	unsigned char m_hash[16];

	inline static void HexByte( std::ostream& out, unsigned char x )
	{
		static const char * hexbytes = "0123456789abcdef";
		out << hexbytes[x>>4] << hexbytes[x&0xf];
	}
};

#endif
