#include "hashcache.h"
#include "winexcept.h"

CHashCache GetHash;

struct AutoCloseHandle
{
	AutoCloseHandle(HANDLE hdl) : m_hdl(hdl) {}
	~AutoCloseHandle() { CloseHandle(m_hdl); }
	HANDLE m_hdl;
};

CHash CHashCache::operator ()( const std::string& filename, IHashProgressCallback * pProgress )
{
	CMutex::Lock lock( m_mutex );

	TMap::iterator iter = m_cache.find( filename );
	if (iter == m_cache.end())
		return NewHash(filename, pProgress);
	SFileInfo curInfo(filename);
	if (curInfo != iter->second.info)
		return NewHash(filename, pProgress);
	return iter->second.hash;
}

CHash CHashCache::NewHash( const std::string& filename, IHashProgressCallback * pProgress )
{
	std::cout << "Calculating hash for " << filename << std::endl;
	m_cache.erase( filename );
	SCacheEntry entry(filename, pProgress);
	m_cache[filename] = entry;
	return entry.hash;
}

CHashCache::SFileInfo::SFileInfo( const std::string& filename )
{
	HANDLE handle = CreateFile(
		filename.c_str(),
		FILE_READ_ATTRIBUTES,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL );
	if (handle == INVALID_HANDLE_VALUE)
		throw CWinException();

	AutoCloseHandle closer(handle);

	if (!GetFileTime( handle, NULL, NULL, &time ))
		throw CWinException();

	sizeLow = GetFileSize( handle, &sizeHigh );
	if (sizeLow == INVALID_FILE_SIZE)
	{
		DWORD err = GetLastError();
		if (err != NO_ERROR)
			throw CWinException(err);
	}
}
