#ifndef ICONHANDLE_H
#define ICONHANDLE_H

#include "winexcept.h"

class CIconHandle
{
public:
	CIconHandle( WORD id ) : m_hIcon((HICON)LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(id), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR))
	{
		if (!m_hIcon)
			throw CWinException();
	}
	~CIconHandle() 
	{
		DestroyIcon( m_hIcon );
	}
	friend HICON GetHIcon( const CIconHandle& h )
	{
		return h.m_hIcon;
	}
private:
	CIconHandle& operator=(const CIconHandle&) {}
	CIconHandle(const CIconHandle&);
	HICON m_hIcon;
};

#endif
