#ifndef MENUHANDLE_H
#define MENUHANDLE_H

#include "winexcept.h"

class CMenuHandle
{
public:
	CMenuHandle( WORD id ) : m_hMenu(LoadMenu(GetModuleHandle(NULL), MAKEINTRESOURCE(id)))
	{
		if (!m_hMenu)
			throw CWinException();
	}
	~CMenuHandle() 
	{
		DestroyMenu( m_hMenu );
	}
	friend HMENU GetHMenu( const CMenuHandle& h )
	{
		return h.m_hMenu;
	}
private:
	CMenuHandle& operator=(const CMenuHandle&) {}
	CMenuHandle(const CMenuHandle&);
	HMENU m_hMenu;
};

#endif
