#ifndef MUTEX_H
#define MUTEX_H

#include <windows.h>

class CMutex
{
public:
	CMutex()
	{
		InitializeCriticalSection( &m_critSection );
	}
	~CMutex()
	{
		DeleteCriticalSection( &m_critSection );
	}

	class Lock
	{
	public:
		Lock( CMutex& mtx ) : m_pCS(&mtx.m_critSection) 
		{
			EnterCriticalSection( m_pCS );
		}
		~Lock() 
		{ 
			LeaveCriticalSection( m_pCS );
		}

	private:
		Lock( const Lock& );
		Lock& operator=( const Lock& );

		CRITICAL_SECTION * m_pCS;
	};

private:
	CMutex( const CMutex& );
	CMutex& operator=( const CMutex& );
	CRITICAL_SECTION m_critSection;
};

#endif
