#ifndef TEMPQUEUE_H
#define TEMPQUEUE_H

#include <map>
#include <queue>
#include <time.h>

template <class T>
class CTempQueue
{
public:
	void Add( time_t howLong, const T& value )
	{
		Flush();
		m_values[value]++;
		m_queue.push( SQueueEntry(time(NULL)+howLong, value) );
	}

	bool Has( const T& value )
	{
		return m_values.find(value) != m_values.end();
	}

private:
	struct SQueueEntry
	{
		SQueueEntry( time_t when, const T& value ) { this->when = when; this->value = value; }
		bool operator<( const SQueueEntry& rhs ) const
		{
			return when > rhs.when;
		}
		time_t when;
		T value;
	};

	std::priority_queue<SQueueEntry> m_queue;
	std::map<T, int> m_values;

	void Flush()
	{
		time_t now = time(NULL);
		while (!m_queue.empty() && m_queue.top().when < now)
		{
			if (0 == --m_values[m_queue.top().value])
				m_values.erase(m_queue.top().value);
			m_queue.pop();
		}
	}
};

#endif
