#include "winexcept.h"

CWinException::CWinException( DWORD code ) : std::runtime_error(Format(code))
{
}

std::string CWinException::Format( DWORD code )
{
	LPVOID lpMsgBuf;
	if (!FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL ))
	{
		char buf[128];
		sprintf( buf, "Unknown windows exception %.8x", code );
		return buf;
	}

	std::string output( (const char *)lpMsgBuf );

	// Free the buffer.
	LocalFree( lpMsgBuf );

	return output;
}
