using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Net;


namespace BuildMonkey
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class BuildMonkey : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Button m_BuildButton;
        private System.Windows.Forms.GroupBox m_LabelGroupBox;
        private System.Windows.Forms.GroupBox m_BuildTypeGroup;
        private System.Windows.Forms.RadioButton m_BuildTypeFull;
        private System.Windows.Forms.RadioButton m_BuildTypeCode;
        private System.Windows.Forms.RadioButton m_BuildTypeArt;
        private System.Windows.Forms.GroupBox m_BuildOptionsGroup;
        private System.Windows.Forms.CheckBox m_UseIncrediBuild;
        private System.Windows.Forms.CheckBox m_FastBuild;
        private System.Windows.Forms.RadioButton m_BuildTypeInstallshield;
        private System.Windows.Forms.ComboBox m_ComboBuildConfig;
        private System.Windows.Forms.TextBox m_custom_email;
        private System.Windows.Forms.CheckBox m_use_custom_email;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.TextBox m_RC_Image_Arguments;
        private System.Windows.Forms.TextBox m_RC_Animation_Arguments;
        private System.Windows.Forms.CheckBox m_exitOnP4Check;
        private System.Windows.Forms.ComboBox m_Project;
        private System.Windows.Forms.GroupBox groupBox3;
        private System.Windows.Forms.TextBox m_Name_Extension;
        private System.Windows.Forms.CheckBox m_BranchBuild;
        private System.Windows.Forms.Button m_Edit_WS;
        private string strHostName = Dns.GetHostName();
        private System.Windows.Forms.GroupBox m_RC_CompilerGroup;
        private System.Windows.Forms.GroupBox m_AdditionalBuildMailInfoGroup;
        private System.Windows.Forms.GroupBox m_BuildNameExtGroup;
        private System.Windows.Forms.GroupBox m_BranchBuildGroup;
        private System.Windows.Forms.CheckBox m_DiffBuild;
        private System.Windows.Forms.GroupBox m_VSV_groupBox;
        private System.Windows.Forms.RadioButton m_VS05;
        private System.Windows.Forms.RadioButton m_VS03;
        private CheckBox m_RebuildCode;
        private TextBox m_AssetLabel;
        private CheckBox m_UseAssetLabel;
        private TextBox m_CodeLabel;
        private CheckBox m_UseCodeLabel;
        private Label label5;
        private Label label4;
        private ComboBox m_ComboPlatform;
        private System.ComponentModel.IContainer components;

        public BuildMonkey()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            // Create Tooltips for the gui
            /*InitToolTips();

            toolTip1.SetToolTip (m_BuildButton, "This is tooltip test");
            toolTip1.Active = true;*/

            CreateEditWSButtonText();

            DisableOptionsOnMachine();
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(BuildMonkey));
            this.m_BuildButton = new System.Windows.Forms.Button();
            this.m_LabelGroupBox = new System.Windows.Forms.GroupBox();
            this.m_AssetLabel = new System.Windows.Forms.TextBox();
            this.m_UseAssetLabel = new System.Windows.Forms.CheckBox();
            this.m_CodeLabel = new System.Windows.Forms.TextBox();
            this.m_UseCodeLabel = new System.Windows.Forms.CheckBox();
            this.m_BuildTypeGroup = new System.Windows.Forms.GroupBox();
            this.m_BuildTypeInstallshield = new System.Windows.Forms.RadioButton();
            this.m_BuildTypeArt = new System.Windows.Forms.RadioButton();
            this.m_BuildTypeCode = new System.Windows.Forms.RadioButton();
            this.m_BuildTypeFull = new System.Windows.Forms.RadioButton();
            this.m_BuildOptionsGroup = new System.Windows.Forms.GroupBox();
            this.m_RebuildCode = new System.Windows.Forms.CheckBox();
            this.m_DiffBuild = new System.Windows.Forms.CheckBox();
            this.m_exitOnP4Check = new System.Windows.Forms.CheckBox();
            this.m_FastBuild = new System.Windows.Forms.CheckBox();
            this.m_UseIncrediBuild = new System.Windows.Forms.CheckBox();
            this.m_ComboBuildConfig = new System.Windows.Forms.ComboBox();
            this.m_custom_email = new System.Windows.Forms.TextBox();
            this.m_RC_Animation_Arguments = new System.Windows.Forms.TextBox();
            this.m_RC_CompilerGroup = new System.Windows.Forms.GroupBox();
            this.label3 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.m_RC_Image_Arguments = new System.Windows.Forms.TextBox();
            this.m_use_custom_email = new System.Windows.Forms.CheckBox();
            this.m_AdditionalBuildMailInfoGroup = new System.Windows.Forms.GroupBox();
            this.m_Project = new System.Windows.Forms.ComboBox();
            this.groupBox3 = new System.Windows.Forms.GroupBox();
            this.m_BuildNameExtGroup = new System.Windows.Forms.GroupBox();
            this.m_Name_Extension = new System.Windows.Forms.TextBox();
            this.m_BranchBuild = new System.Windows.Forms.CheckBox();
            this.m_Edit_WS = new System.Windows.Forms.Button();
            this.m_BranchBuildGroup = new System.Windows.Forms.GroupBox();
            this.m_VSV_groupBox = new System.Windows.Forms.GroupBox();
            this.m_VS05 = new System.Windows.Forms.RadioButton();
            this.m_VS03 = new System.Windows.Forms.RadioButton();
            this.m_ComboPlatform = new System.Windows.Forms.ComboBox();
            this.label4 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.m_LabelGroupBox.SuspendLayout();
            this.m_BuildTypeGroup.SuspendLayout();
            this.m_BuildOptionsGroup.SuspendLayout();
            this.m_RC_CompilerGroup.SuspendLayout();
            this.m_AdditionalBuildMailInfoGroup.SuspendLayout();
            this.m_BuildNameExtGroup.SuspendLayout();
            this.m_BranchBuildGroup.SuspendLayout();
            this.m_VSV_groupBox.SuspendLayout();
            this.SuspendLayout();
            // 
            // m_BuildButton
            // 
            this.m_BuildButton.Font = new System.Drawing.Font("Arial Black", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.m_BuildButton.Location = new System.Drawing.Point(203, 521);
            this.m_BuildButton.Name = "m_BuildButton";
            this.m_BuildButton.Size = new System.Drawing.Size(293, 64);
            this.m_BuildButton.TabIndex = 0;
            this.m_BuildButton.Text = "Start Build";
            this.m_BuildButton.Click += new System.EventHandler(this.BuildButton_Click);
            // 
            // m_LabelGroupBox
            // 
            this.m_LabelGroupBox.Controls.Add(this.m_AssetLabel);
            this.m_LabelGroupBox.Controls.Add(this.m_UseAssetLabel);
            this.m_LabelGroupBox.Controls.Add(this.m_CodeLabel);
            this.m_LabelGroupBox.Controls.Add(this.m_UseCodeLabel);
            this.m_LabelGroupBox.Location = new System.Drawing.Point(192, 16);
            this.m_LabelGroupBox.Name = "m_LabelGroupBox";
            this.m_LabelGroupBox.Size = new System.Drawing.Size(304, 89);
            this.m_LabelGroupBox.TabIndex = 8;
            this.m_LabelGroupBox.TabStop = false;
            this.m_LabelGroupBox.Text = "Perforce Label";
            // 
            // m_AssetLabel
            // 
            this.m_AssetLabel.Enabled = false;
            this.m_AssetLabel.Location = new System.Drawing.Point(119, 59);
            this.m_AssetLabel.Name = "m_AssetLabel";
            this.m_AssetLabel.Size = new System.Drawing.Size(169, 20);
            this.m_AssetLabel.TabIndex = 18;
            // 
            // m_UseAssetLabel
            // 
            this.m_UseAssetLabel.AutoSize = true;
            this.m_UseAssetLabel.Location = new System.Drawing.Point(11, 59);
            this.m_UseAssetLabel.Name = "m_UseAssetLabel";
            this.m_UseAssetLabel.Size = new System.Drawing.Size(103, 17);
            this.m_UseAssetLabel.TabIndex = 17;
            this.m_UseAssetLabel.Text = "Use Asset Label";
            this.m_UseAssetLabel.UseVisualStyleBackColor = true;
            this.m_UseAssetLabel.CheckedChanged += new System.EventHandler(this.m_UseAssetLabel_CheckedChanged);
            // 
            // m_CodeLabel
            // 
            this.m_CodeLabel.Enabled = false;
            this.m_CodeLabel.Location = new System.Drawing.Point(119, 24);
            this.m_CodeLabel.Name = "m_CodeLabel";
            this.m_CodeLabel.Size = new System.Drawing.Size(169, 20);
            this.m_CodeLabel.TabIndex = 16;
            // 
            // m_UseCodeLabel
            // 
            this.m_UseCodeLabel.AutoSize = true;
            this.m_UseCodeLabel.Location = new System.Drawing.Point(11, 24);
            this.m_UseCodeLabel.Name = "m_UseCodeLabel";
            this.m_UseCodeLabel.Size = new System.Drawing.Size(102, 17);
            this.m_UseCodeLabel.TabIndex = 15;
            this.m_UseCodeLabel.Text = "Use Code Label";
            this.m_UseCodeLabel.UseVisualStyleBackColor = true;
            this.m_UseCodeLabel.CheckedChanged += new System.EventHandler(this.m_UseCodeLabel_CheckedChanged);
            // 
            // m_BuildTypeGroup
            // 
            this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeInstallshield);
            this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeArt);
            this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeCode);
            this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeFull);
            this.m_BuildTypeGroup.Location = new System.Drawing.Point(16, 88);
            this.m_BuildTypeGroup.Name = "m_BuildTypeGroup";
            this.m_BuildTypeGroup.Size = new System.Drawing.Size(160, 152);
            this.m_BuildTypeGroup.TabIndex = 1;
            this.m_BuildTypeGroup.TabStop = false;
            this.m_BuildTypeGroup.Text = "Build Type";
            // 
            // m_BuildTypeInstallshield
            // 
            this.m_BuildTypeInstallshield.Enabled = false;
            this.m_BuildTypeInstallshield.Location = new System.Drawing.Point(16, 120);
            this.m_BuildTypeInstallshield.Name = "m_BuildTypeInstallshield";
            this.m_BuildTypeInstallshield.Size = new System.Drawing.Size(112, 24);
            this.m_BuildTypeInstallshield.TabIndex = 5;
            this.m_BuildTypeInstallshield.Text = "InstallShield Build";
            this.m_BuildTypeInstallshield.CheckedChanged += new System.EventHandler(this.m_BuildTypeInstallshield_CheckedChanged);
            // 
            // m_BuildTypeArt
            // 
            this.m_BuildTypeArt.Location = new System.Drawing.Point(16, 88);
            this.m_BuildTypeArt.Name = "m_BuildTypeArt";
            this.m_BuildTypeArt.Size = new System.Drawing.Size(80, 24);
            this.m_BuildTypeArt.TabIndex = 4;
            this.m_BuildTypeArt.Text = "Art Build";
            this.m_BuildTypeArt.CheckedChanged += new System.EventHandler(this.BuildTypeArt_CheckedChanged);
            // 
            // m_BuildTypeCode
            // 
            this.m_BuildTypeCode.Location = new System.Drawing.Point(16, 56);
            this.m_BuildTypeCode.Name = "m_BuildTypeCode";
            this.m_BuildTypeCode.Size = new System.Drawing.Size(80, 24);
            this.m_BuildTypeCode.TabIndex = 3;
            this.m_BuildTypeCode.Text = "Code Build";
            this.m_BuildTypeCode.CheckedChanged += new System.EventHandler(this.BuildTypeCode_CheckedChanged);
            // 
            // m_BuildTypeFull
            // 
            this.m_BuildTypeFull.Checked = true;
            this.m_BuildTypeFull.Location = new System.Drawing.Point(16, 24);
            this.m_BuildTypeFull.Name = "m_BuildTypeFull";
            this.m_BuildTypeFull.Size = new System.Drawing.Size(80, 24);
            this.m_BuildTypeFull.TabIndex = 2;
            this.m_BuildTypeFull.TabStop = true;
            this.m_BuildTypeFull.Text = "Full Build";
            this.m_BuildTypeFull.CheckedChanged += new System.EventHandler(this.BuildTypeFull_CheckedChanged);
            // 
            // m_BuildOptionsGroup
            // 
            this.m_BuildOptionsGroup.Controls.Add(this.label5);
            this.m_BuildOptionsGroup.Controls.Add(this.label4);
            this.m_BuildOptionsGroup.Controls.Add(this.m_ComboPlatform);
            this.m_BuildOptionsGroup.Controls.Add(this.m_RebuildCode);
            this.m_BuildOptionsGroup.Controls.Add(this.m_DiffBuild);
            this.m_BuildOptionsGroup.Controls.Add(this.m_exitOnP4Check);
            this.m_BuildOptionsGroup.Controls.Add(this.m_FastBuild);
            this.m_BuildOptionsGroup.Controls.Add(this.m_UseIncrediBuild);
            this.m_BuildOptionsGroup.Controls.Add(this.m_ComboBuildConfig);
            this.m_BuildOptionsGroup.Location = new System.Drawing.Point(16, 246);
            this.m_BuildOptionsGroup.Name = "m_BuildOptionsGroup";
            this.m_BuildOptionsGroup.Size = new System.Drawing.Size(160, 256);
            this.m_BuildOptionsGroup.TabIndex = 5;
            this.m_BuildOptionsGroup.TabStop = false;
            this.m_BuildOptionsGroup.Text = "Build Options";
            // 
            // m_RebuildCode
            // 
            this.m_RebuildCode.Checked = true;
            this.m_RebuildCode.CheckState = System.Windows.Forms.CheckState.Checked;
            this.m_RebuildCode.Location = new System.Drawing.Point(16, 103);
            this.m_RebuildCode.Name = "m_RebuildCode";
            this.m_RebuildCode.Size = new System.Drawing.Size(112, 24);
            this.m_RebuildCode.TabIndex = 11;
            this.m_RebuildCode.Text = "Rebuild Code";
            // 
            // m_DiffBuild
            // 
            this.m_DiffBuild.Checked = true;
            this.m_DiffBuild.CheckState = System.Windows.Forms.CheckState.Checked;
            this.m_DiffBuild.Enabled = false;
            this.m_DiffBuild.Location = new System.Drawing.Point(16, 130);
            this.m_DiffBuild.Name = "m_DiffBuild";
            this.m_DiffBuild.Size = new System.Drawing.Size(112, 24);
            this.m_DiffBuild.TabIndex = 10;
            this.m_DiffBuild.Text = "DiffBuild";
            this.m_DiffBuild.CheckedChanged += new System.EventHandler(this.m_DiffBuild_CheckedChanged);
            // 
            // m_exitOnP4Check
            // 
            this.m_exitOnP4Check.Checked = true;
            this.m_exitOnP4Check.CheckState = System.Windows.Forms.CheckState.Checked;
            this.m_exitOnP4Check.Location = new System.Drawing.Point(16, 42);
            this.m_exitOnP4Check.Name = "m_exitOnP4Check";
            this.m_exitOnP4Check.Size = new System.Drawing.Size(136, 32);
            this.m_exitOnP4Check.TabIndex = 7;
            this.m_exitOnP4Check.Text = "Build even no code changes are available";
            // 
            // m_FastBuild
            // 
            this.m_FastBuild.Checked = true;
            this.m_FastBuild.CheckState = System.Windows.Forms.CheckState.Checked;
            this.m_FastBuild.Location = new System.Drawing.Point(16, 77);
            this.m_FastBuild.Name = "m_FastBuild";
            this.m_FastBuild.Size = new System.Drawing.Size(112, 24);
            this.m_FastBuild.TabIndex = 8;
            this.m_FastBuild.Text = "Fast Build";
            // 
            // m_UseIncrediBuild
            // 
            this.m_UseIncrediBuild.Checked = true;
            this.m_UseIncrediBuild.CheckState = System.Windows.Forms.CheckState.Checked;
            this.m_UseIncrediBuild.Location = new System.Drawing.Point(16, 18);
            this.m_UseIncrediBuild.Name = "m_UseIncrediBuild";
            this.m_UseIncrediBuild.Size = new System.Drawing.Size(112, 24);
            this.m_UseIncrediBuild.TabIndex = 6;
            this.m_UseIncrediBuild.Text = "Use IncrediBuild";
            // 
            // m_ComboBuildConfig
            // 
            this.m_ComboBuildConfig.Items.AddRange(new object[] {
            "Profile",
            "Release",
            "Debug"});
            this.m_ComboBuildConfig.Location = new System.Drawing.Point(16, 176);
            this.m_ComboBuildConfig.Name = "m_ComboBuildConfig";
            this.m_ComboBuildConfig.Size = new System.Drawing.Size(112, 21);
            this.m_ComboBuildConfig.TabIndex = 9;
            this.m_ComboBuildConfig.Text = "Profile";
            this.m_ComboBuildConfig.SelectedIndexChanged += new System.EventHandler(this.m_ComboBuildConfig_SelectedIndexChanged);
            // 
            // m_custom_email
            // 
            this.m_custom_email.Enabled = false;
            this.m_custom_email.Location = new System.Drawing.Point(16, 48);
            this.m_custom_email.Multiline = true;
            this.m_custom_email.Name = "m_custom_email";
            this.m_custom_email.Size = new System.Drawing.Size(280, 40);
            this.m_custom_email.TabIndex = 16;
            this.m_custom_email.Text = "Please type your name and the reason for making a new build here.";
            this.m_custom_email.TextChanged += new System.EventHandler(this.m_custom_email_text_TextChanged);
            // 
            // m_RC_Animation_Arguments
            // 
            this.m_RC_Animation_Arguments.Location = new System.Drawing.Point(88, 56);
            this.m_RC_Animation_Arguments.Multiline = true;
            this.m_RC_Animation_Arguments.Name = "m_RC_Animation_Arguments";
            this.m_RC_Animation_Arguments.Size = new System.Drawing.Size(208, 24);
            this.m_RC_Animation_Arguments.TabIndex = 18;
            // 
            // m_RC_CompilerGroup
            // 
            this.m_RC_CompilerGroup.Controls.Add(this.label3);
            this.m_RC_CompilerGroup.Controls.Add(this.label2);
            this.m_RC_CompilerGroup.Controls.Add(this.label1);
            this.m_RC_CompilerGroup.Controls.Add(this.m_RC_Image_Arguments);
            this.m_RC_CompilerGroup.Controls.Add(this.m_RC_Animation_Arguments);
            this.m_RC_CompilerGroup.Location = new System.Drawing.Point(192, 112);
            this.m_RC_CompilerGroup.Name = "m_RC_CompilerGroup";
            this.m_RC_CompilerGroup.Size = new System.Drawing.Size(304, 112);
            this.m_RC_CompilerGroup.TabIndex = 17;
            this.m_RC_CompilerGroup.TabStop = false;
            this.m_RC_CompilerGroup.Text = "Resource Compiler Arguments";
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(8, 88);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(288, 16);
            this.label3.TabIndex = 14;
            this.label3.Text = "eg:                     /globalreduce=1 /globalgamma=2.2";
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(8, 56);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(80, 16);
            this.label2.TabIndex = 13;
            this.label2.Text = "RC Animation:";
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(8, 24);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(72, 24);
            this.label1.TabIndex = 12;
            this.label1.Text = "RC Image:";
            this.label1.Click += new System.EventHandler(this.label1_Click);
            // 
            // m_RC_Image_Arguments
            // 
            this.m_RC_Image_Arguments.Location = new System.Drawing.Point(88, 24);
            this.m_RC_Image_Arguments.Multiline = true;
            this.m_RC_Image_Arguments.Name = "m_RC_Image_Arguments";
            this.m_RC_Image_Arguments.Size = new System.Drawing.Size(208, 24);
            this.m_RC_Image_Arguments.TabIndex = 17;
            // 
            // m_use_custom_email
            // 
            this.m_use_custom_email.Location = new System.Drawing.Point(16, 24);
            this.m_use_custom_email.Name = "m_use_custom_email";
            this.m_use_custom_email.Size = new System.Drawing.Size(224, 16);
            this.m_use_custom_email.TabIndex = 15;
            this.m_use_custom_email.Text = "Use additional build mail informations";
            this.m_use_custom_email.CheckedChanged += new System.EventHandler(this.m_use_custom_email_CheckedChanged);
            // 
            // m_AdditionalBuildMailInfoGroup
            // 
            this.m_AdditionalBuildMailInfoGroup.Controls.Add(this.m_use_custom_email);
            this.m_AdditionalBuildMailInfoGroup.Controls.Add(this.m_custom_email);
            this.m_AdditionalBuildMailInfoGroup.Location = new System.Drawing.Point(192, 230);
            this.m_AdditionalBuildMailInfoGroup.Name = "m_AdditionalBuildMailInfoGroup";
            this.m_AdditionalBuildMailInfoGroup.Size = new System.Drawing.Size(304, 96);
            this.m_AdditionalBuildMailInfoGroup.TabIndex = 13;
            this.m_AdditionalBuildMailInfoGroup.TabStop = false;
            this.m_AdditionalBuildMailInfoGroup.Text = "Additional Build Mail informations";
            // 
            // m_Project
            // 
            this.m_Project.ItemHeight = 13;
            this.m_Project.Items.AddRange(new object[] {
            "Game02",
            "Game04"});
            this.m_Project.Location = new System.Drawing.Point(32, 40);
            this.m_Project.Name = "m_Project";
            this.m_Project.Size = new System.Drawing.Size(128, 21);
            this.m_Project.Sorted = true;
            this.m_Project.TabIndex = 1;
            this.m_Project.Text = "Game02";
            this.m_Project.SelectedIndexChanged += new System.EventHandler(this.m_project_SelectedIndexChanged);
            // 
            // groupBox3
            // 
            this.groupBox3.Location = new System.Drawing.Point(16, 16);
            this.groupBox3.Name = "groupBox3";
            this.groupBox3.Size = new System.Drawing.Size(160, 56);
            this.groupBox3.TabIndex = 18;
            this.groupBox3.TabStop = false;
            this.groupBox3.Text = "Project";
            this.groupBox3.Enter += new System.EventHandler(this.groupBox3_Enter);
            // 
            // m_BuildNameExtGroup
            // 
            this.m_BuildNameExtGroup.Controls.Add(this.m_Name_Extension);
            this.m_BuildNameExtGroup.Location = new System.Drawing.Point(192, 332);
            this.m_BuildNameExtGroup.Name = "m_BuildNameExtGroup";
            this.m_BuildNameExtGroup.Size = new System.Drawing.Size(304, 56);
            this.m_BuildNameExtGroup.TabIndex = 19;
            this.m_BuildNameExtGroup.TabStop = false;
            this.m_BuildNameExtGroup.Text = "Build Name Extension";
            this.m_BuildNameExtGroup.Enter += new System.EventHandler(this.groupBox4_Enter);
            // 
            // m_Name_Extension
            // 
            this.m_Name_Extension.Location = new System.Drawing.Point(16, 24);
            this.m_Name_Extension.MaxLength = 59;
            this.m_Name_Extension.Name = "m_Name_Extension";
            this.m_Name_Extension.Size = new System.Drawing.Size(272, 20);
            this.m_Name_Extension.TabIndex = 0;
            this.m_Name_Extension.TextChanged += new System.EventHandler(this.textBox1_TextChanged);
            // 
            // m_BranchBuild
            // 
            this.m_BranchBuild.AccessibleDescription = "";
            this.m_BranchBuild.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.m_BranchBuild.Location = new System.Drawing.Point(16, 24);
            this.m_BranchBuild.Name = "m_BranchBuild";
            this.m_BranchBuild.Size = new System.Drawing.Size(136, 16);
            this.m_BranchBuild.TabIndex = 20;
            this.m_BranchBuild.Text = "Enable Branch Build";
            this.m_BranchBuild.CheckedChanged += new System.EventHandler(this.m_MsBuild_CheckedChanged);
            // 
            // m_Edit_WS
            // 
            this.m_Edit_WS.Location = new System.Drawing.Point(11, 50);
            this.m_Edit_WS.Name = "m_Edit_WS";
            this.m_Edit_WS.Size = new System.Drawing.Size(277, 40);
            this.m_Edit_WS.TabIndex = 21;
            this.m_Edit_WS.Text = "Edit Workspace \"Build_Game02_Branch\"";
            this.m_Edit_WS.Click += new System.EventHandler(this.button1_Click);
            // 
            // m_BranchBuildGroup
            // 
            this.m_BranchBuildGroup.Controls.Add(this.m_BranchBuild);
            this.m_BranchBuildGroup.Controls.Add(this.m_Edit_WS);
            this.m_BranchBuildGroup.Location = new System.Drawing.Point(192, 394);
            this.m_BranchBuildGroup.Name = "m_BranchBuildGroup";
            this.m_BranchBuildGroup.Size = new System.Drawing.Size(304, 104);
            this.m_BranchBuildGroup.TabIndex = 22;
            this.m_BranchBuildGroup.TabStop = false;
            this.m_BranchBuildGroup.Text = "Branch Build";
            // 
            // m_VSV_groupBox
            // 
            this.m_VSV_groupBox.Controls.Add(this.m_VS05);
            this.m_VSV_groupBox.Controls.Add(this.m_VS03);
            this.m_VSV_groupBox.Location = new System.Drawing.Point(16, 509);
            this.m_VSV_groupBox.Name = "m_VSV_groupBox";
            this.m_VSV_groupBox.Size = new System.Drawing.Size(160, 88);
            this.m_VSV_groupBox.TabIndex = 23;
            this.m_VSV_groupBox.TabStop = false;
            this.m_VSV_groupBox.Text = "Visual Studio version";
            // 
            // m_VS05
            // 
            this.m_VS05.Checked = true;
            this.m_VS05.Location = new System.Drawing.Point(16, 24);
            this.m_VS05.Name = "m_VS05";
            this.m_VS05.Size = new System.Drawing.Size(128, 24);
            this.m_VS05.TabIndex = 3;
            this.m_VS05.TabStop = true;
            this.m_VS05.Text = "Visual Studio 2005 ";
            this.m_VS05.CheckedChanged += new System.EventHandler(this.m_VS05_CheckedChanged);
            // 
            // m_VS03
            // 
            this.m_VS03.Location = new System.Drawing.Point(16, 56);
            this.m_VS03.Name = "m_VS03";
            this.m_VS03.Size = new System.Drawing.Size(128, 24);
            this.m_VS03.TabIndex = 2;
            this.m_VS03.Text = "Visual Studio 2003";
            this.m_VS03.CheckedChanged += new System.EventHandler(this.m_VS03_CheckedChanged);
            // 
            // m_ComboPlatform
            // 
            this.m_ComboPlatform.Items.AddRange(new object[] {
            "pc",
            "ps3",
            "xbox"});
            this.m_ComboPlatform.Location = new System.Drawing.Point(16, 225);
            this.m_ComboPlatform.Name = "m_ComboPlatform";
            this.m_ComboPlatform.Size = new System.Drawing.Size(112, 21);
            this.m_ComboPlatform.TabIndex = 12;
            this.m_ComboPlatform.Text = "pc";
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(13, 207);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(115, 18);
            this.label4.TabIndex = 19;
            this.label4.Text = "Platform:";
            // 
            // label5
            // 
            this.label5.Location = new System.Drawing.Point(13, 158);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(115, 18);
            this.label5.TabIndex = 20;
            this.label5.Text = "Compile Config:";
            // 
            // BuildMonkey
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(516, 605);
            this.Controls.Add(this.m_VSV_groupBox);
            this.Controls.Add(this.m_BuildNameExtGroup);
            this.Controls.Add(this.m_Project);
            this.Controls.Add(this.m_BuildOptionsGroup);
            this.Controls.Add(this.m_BuildTypeGroup);
            this.Controls.Add(this.m_LabelGroupBox);
            this.Controls.Add(this.m_BuildButton);
            this.Controls.Add(this.m_RC_CompilerGroup);
            this.Controls.Add(this.m_AdditionalBuildMailInfoGroup);
            this.Controls.Add(this.groupBox3);
            this.Controls.Add(this.m_BranchBuildGroup);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.Name = "BuildMonkey";
            this.Text = "BuildMonkey";
            this.m_LabelGroupBox.ResumeLayout(false);
            this.m_LabelGroupBox.PerformLayout();
            this.m_BuildTypeGroup.ResumeLayout(false);
            this.m_BuildOptionsGroup.ResumeLayout(false);
            this.m_RC_CompilerGroup.ResumeLayout(false);
            this.m_RC_CompilerGroup.PerformLayout();
            this.m_AdditionalBuildMailInfoGroup.ResumeLayout(false);
            this.m_AdditionalBuildMailInfoGroup.PerformLayout();
            this.m_BuildNameExtGroup.ResumeLayout(false);
            this.m_BuildNameExtGroup.PerformLayout();
            this.m_BranchBuildGroup.ResumeLayout(false);
            this.m_VSV_groupBox.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.Run(new BuildMonkey());
        }

        private void DisableOptionsOnMachine()
        {
            if (strHostName == "PC106")
                m_DiffBuild.Enabled = true;
            //MessageBox.Show(strHostName);
        }

        // Change the "edit workspace.." button text depending on the machine name and project selected
        private void CreateEditWSButtonText()
        {
            string build_project = m_Project.Text;
            string workspaceName = "\"Build_" + System.Environment.MachineName + "_" + build_project + "_Branch\"";
            
            m_Edit_WS.Text = "Edit Workspace " + workspaceName.ToLower();
        }



        private string GetAssetLabel()
        {
            if (m_UseAssetLabel.Checked)
                return m_AssetLabel.Text;

            return "";
        }

        private string GetCodeLabel()
        {
            if (m_UseCodeLabel.Checked)
                return m_CodeLabel.Text;

            return "";
        }

        private string GetBuildType()
        {
            if (m_BuildTypeCode.Checked)
                return "Code";

            if (m_BuildTypeArt.Checked)
                return "Art";

            if (m_BuildTypeInstallshield.Checked)
                return "Installshield";

            return "Full";
        }

        private string GetVSVersion()
        {
            if (m_VS03.Checked && m_VS03.Enabled)
                return "VS03";

            if (m_VS05.Checked && m_VS05.Enabled)
                return "VS05";

            return "";
        }


        private string GetCustom_email()
        {
            if (m_use_custom_email.Checked)
                return m_custom_email.Text;

            return "";
        }



        private void BuildButton_Click(object sender, System.EventArgs e)
        {
            // build command-line
            string cmdLine, currentdir = Directory.GetCurrentDirectory();

            cmdLine = "buildmonkey_build.wsf";

            // Passing name of project to jscript
            string build_project = m_Project.Text;
            switch (build_project)
            {
                case "Game02":
                    cmdLine += " /Project:Game02";
                    break;
                case "Game04":
                    cmdLine += " /Project:Game04";
                    break;
            }

            // Passing the name extension
            string Name_Extension = "_";
            Name_Extension += m_Name_Extension.Text;
            if (Name_Extension != "_")
            {
                Name_Extension = Name_Extension.Replace(" ", "_");
                cmdLine += " /NameExtension:" + Name_Extension;
            }

            // Passing the ExitOnP4Check state to the jscript
            if (m_exitOnP4Check.Checked && m_exitOnP4Check.Enabled)
                cmdLine += " /ExitOnP4Check:false";
            else if (!m_exitOnP4Check.Checked || !m_exitOnP4Check.Enabled)
                cmdLine += " /ExitOnP4Check:true";

            // RC Arguments
            string RC_Image_Arguments, RC_Animation_Arguments;
            RC_Image_Arguments = m_RC_Image_Arguments.Text;
            RC_Animation_Arguments = m_RC_Animation_Arguments.Text;
            if (RC_Image_Arguments != "")
            {
                RC_Image_Arguments = RC_Image_Arguments.Replace(" /", "_/");
                cmdLine += " /RC_Image_Arguments:" + RC_Image_Arguments;
            }
            if (RC_Animation_Arguments != "")
            {
                RC_Animation_Arguments = RC_Animation_Arguments.Replace(" /", "_/");
                cmdLine += " /RC_Animation_Arguments:" + RC_Animation_Arguments;
            }

            // email additions
            string emailadditions = GetCustom_email();
            if (emailadditions != "")
            {
                emailadditions = emailadditions.Replace(" ", "_");
                cmdLine += " /emailadditions:" + emailadditions;
            }

            // labeled build
            string assetLabel = GetAssetLabel();
            if (assetLabel != "")
            {
                cmdLine += " /p4AssetLabel:" + assetLabel;
            }

            // labeled build
            string codeLabel = GetCodeLabel();
            if (codeLabel != "")
            {
                cmdLine += " /p4CodeLabel:" + codeLabel;
            }

            // kind of build
            string buildType = GetBuildType();
            if (buildType != "")
            {
                cmdLine += " /BuildType:" + buildType;
            }

            // config to use for build
            cmdLine += " /BuildConfig:" + m_ComboBuildConfig.Text;

            // config to use for build
            cmdLine += " /platform:" + m_ComboPlatform.Text;

            // try to use IncrediBuild
            if (m_UseIncrediBuild.Enabled && m_UseIncrediBuild.Checked)
                cmdLine += " /UseIncrediBuild:true";
            else if (!m_UseIncrediBuild.Enabled || !m_UseIncrediBuild.Checked)
                cmdLine += " /UseIncrediBuild:false";

            // Choose whether all assets should only be quick-updated
            if (m_FastBuild.Enabled && m_FastBuild.Checked)
                cmdLine += " /FastBuild:true";
            else if (!m_FastBuild.Enabled || !m_FastBuild.Checked)
                cmdLine += " /FastBuild:false";

            // Choose whether only a quick differnces build should be made
            if (m_DiffBuild.Enabled && m_DiffBuild.Checked)
                cmdLine += " /DiffBuild";

            // Choose whether all assets should only be quick-updated
            if (m_BranchBuild.Enabled && m_BranchBuild.Checked)
            {
                cmdLine += " /BranchBuild";
            }

            string VS_Version = GetVSVersion();
            // Choose whether this build should be compiled with Visual Studio 2003 or 2005
            if (VS_Version != "")
            {
                cmdLine += " /" + VS_Version;
            }

            // Choose whether code should be rebuilded
            if (m_RebuildCode.Enabled && m_RebuildCode.Checked)
                cmdLine += " /RebuildCode:true";
            else if (!m_RebuildCode.Enabled || !m_RebuildCode.Checked)
                cmdLine += " /RebuildCode:false";

            // execute the JScript
            //MessageBox.Show(cmdLine);
            System.Diagnostics.Process.Start("cscript", cmdLine);
        }

        private void DoInstallShieldBuild()
        {
            System.Windows.Forms.MessageBox.Show("Make sure that D:/MasterCD_Install/Root contains all files to be included in the build!");
        }



        private void BuildTypeCode_CheckedChanged(object sender, System.EventArgs e)
        {
            m_UseIncrediBuild.Enabled = true;
            m_FastBuild.Enabled = true;
        }

        private void BuildTypeFull_CheckedChanged(object sender, System.EventArgs e)
        {
            if (!m_VS03.Checked)
                m_UseIncrediBuild.Enabled = true;

            m_FastBuild.Enabled = true;
        }

        private void BuildTypeArt_CheckedChanged(object sender, System.EventArgs e)
        {
            m_UseIncrediBuild.Enabled = false;
            m_FastBuild.Enabled = true;
        }

        private void m_BuildTypeInstallshield_CheckedChanged(object sender, System.EventArgs e)
        {
            m_UseIncrediBuild.Enabled = true;
            m_FastBuild.Enabled = true;
        }

        private void m_custom_email_text_TextChanged(object sender, System.EventArgs e)
        {

        }

        private void m_use_custom_email_CheckedChanged(object sender, System.EventArgs e)
        {
            if (m_use_custom_email.Checked)
                m_custom_email.Enabled = true;
            else
                m_custom_email.Enabled = false;
        }

        private void m_ComboBuildConfig_SelectedIndexChanged(object sender, System.EventArgs e)
        {

        }

        private void m_RC_choice_SelectedIndexChanged(object sender, System.EventArgs e)
        {

        }

        private void label1_Click(object sender, System.EventArgs e)
        {

        }

        private void m_project_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            CreateEditWSButtonText();
        }

        private void groupBox3_Enter(object sender, System.EventArgs e)
        {

        }

        private void groupBox4_Enter(object sender, System.EventArgs e)
        {

        }

        private void textBox1_TextChanged(object sender, System.EventArgs e)
        {

        }

        private void m_MsBuild_CheckedChanged(object sender, System.EventArgs e)
        {

        }

        private void button1_Click(object sender, System.EventArgs e)
        {
            string build_project = m_Project.Text;
            string workspaceName = "build_" + System.Environment.MachineName + "_" + build_project + "_Branch";
            string P4CmdLine = " client " + workspaceName.ToLower();
            
            System.Diagnostics.Process Process;
            Process = new System.Diagnostics.Process();
            Process = System.Diagnostics.Process.Start("P4.exe", P4CmdLine);
            Process.WaitForExit();
        }

        private void m_VS03_CheckedChanged(object sender, System.EventArgs e)
        {
            m_UseIncrediBuild.Enabled = false;
        }

        private void m_VS05_CheckedChanged(object sender, System.EventArgs e)
        {
            if (!m_BuildTypeArt.Checked)
                m_UseIncrediBuild.Enabled = true;
        }

        private void m_DiffBuild_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void m_UseCodeLabel_CheckedChanged(object sender, EventArgs e)
        {
            if (m_UseCodeLabel.Checked)
                m_CodeLabel.Enabled = true;
            else
                m_CodeLabel.Enabled = false;
        }

        private void m_UseAssetLabel_CheckedChanged(object sender, EventArgs e)
        {
            if (m_UseAssetLabel.Checked)
                m_AssetLabel.Enabled = true;
            else
                m_AssetLabel.Enabled = false;
        }

    }
}
