// ChartViewerDoc.cpp : implementation of the CChartViewerDoc class
//

#include "stdafx.h"
#include "ChartViewer.h"

#include "ChartViewerDoc.h"
#include "ChartViewerView.h"								// CChartViewerView

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CChartViewerDoc

IMPLEMENT_DYNCREATE(CChartViewerDoc, CDocument)

BEGIN_MESSAGE_MAP(CChartViewerDoc, CDocument)
END_MESSAGE_MAP()


// CChartViewerDoc construction/destruction

CChartViewerDoc::CChartViewerDoc()
{
	// TODO: add one-time construction code here

}

CChartViewerDoc::~CChartViewerDoc()
{
}

BOOL CChartViewerDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}





// CChartViewerDoc diagnostics

#ifdef _DEBUG
void CChartViewerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CChartViewerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CChartViewerDoc commands
SIZE CChartViewerDoc::GetDocSize( CChartData::CChartDisplayInfo &inInfo )
{
	SIZE size;

	int x,y;

	m_Data.GetDimensions(x,y,inInfo);

	size.cx=x/*+CV_RULERWIDTH*/;
	size.cy=y+CV_RULERHEIGHT;

	return(size);
}


void CChartViewerDoc::GetDocDimensions( int &outiMaxPos, int &outiMaxValue ) const
{
	m_Data.GetDimensions(outiMaxPos,outiMaxValue);
}

void CChartViewerDoc::Draw( Graphics *inGraph, CChartData::CChartDisplayInfo &inInfo )
{
	int iMaxPos,iMaxValue;

	m_Data.GetDimensions(iMaxPos,iMaxValue);

	int iWidth,iHeight;

	{
		SIZE siz=GetDocSize(inInfo);

		iWidth=siz.cx;iHeight=siz.cy;
	}

	// horizontal lines
	Color cLineTextColor(0x550000ff);

	SolidBrush brush(cLineTextColor);
	FontFamily fontFamily(L"Times New Roman");
	Font font(&fontFamily, 14, FontStyleRegular, UnitPixel);


	// horizontal lines
	{
//		Pen pen1(cLineTextColor,1);
		int iStep=inInfo.GetYScale16k();
/*
		for(int i=0;i<200;i+=10)
		{
			int y=((iMaxValue-i*10000)*inInfo.GetYScale16k())/(16*1024);

			inGraph->DrawLine(&pen1, 0,y,iWidth,y);
		}
*/
		Pen pen2(cLineTextColor, 1);

		if(iStep>16)
		for(int i=0;;i++)
		{
			int y=((iMaxValue-i*10000)*inInfo.GetYScale16k())/(16*1024);		// 10000 = 10 ms

			if(y<0)break;

			inGraph->DrawLine(&pen2, 0,y,iWidth,y);
		
			WCHAR str[256];
			swprintf(str,L"%d ms",i*10);

			inGraph->DrawString(str,(int)wcslen(str),&font,PointF(0.0f,(float)y-15),&brush);
		}
	}

	// vertical lines
	{

//		Pen pen1(cLineTextColor,1);
//		int iStep=inInfo.GetYScale16k();
/*
		for(int i=0;i<200;i+=10)
		{
			int x=((iMaxValue-i*10000)*inInfo.GetXScale16k())/(16*1024);

			inGraph->DrawLine(&pen1, x,0,x,iHeight);
		}
*/
		Pen pen2(cLineTextColor, 1);

//		if(iStep>16)
		for(int i=0;;i++)
		{
			int x=((i*1000)*inInfo.GetXScale16())/16;		// every sec

			if(x>iWidth)
				break;

			WCHAR str[256];
			swprintf(str,L"%d:%.2d",i/60,i%60);

			inGraph->DrawString(str,(int)wcslen(str),&font,PointF((float)x,(float)iHeight-150),&brush);

			inGraph->DrawLine(&pen2, x,0,x,iHeight);
		}
	}

	m_Data.Draw(inGraph,inInfo);


//	PAINTSTRUCT  ps;



//	Pen pen(Color(CV_RULERPENRGB|0xff000000), 1);
//	Graphics myGraphics(inHdc);



//	HPEN pen=CreatePen(PS_SOLID,1,CV_RULERPENRGB),oldpen;
//	oldpen=(HPEN)SelectObject(inHdc,pen);

	// vertical ruler
/*
	// horizontal ruler (optimizable)
	int iStep=inInfo.GetXScale16()*2;
	for(int x=0,p=0;x<iWidth;x+=2,p+=iStep)
	{
		int h=5;
		
		if(p>50){h+=7;p-=50; }
//		if(p>10)==0)h+=4;

		myGraphics.DrawLine(&pen, x,iHeight-CV_RULERHEIGHT+(CV_RULERHEIGHT*h)/16,
															x,iHeight+2-CV_RULERHEIGHT);
	}

	myGraphics.DrawLine(&pen,0,iHeight-CV_RULERHEIGHT+1,iWidth,iHeight-CV_RULERHEIGHT+1);
*/

//	SelectObject(inHdc,oldpen);

}

BOOL CChartViewerDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;

//	m_Data.GenerateDebugData();return(TRUE);
	if(!m_Data.Load(lpszPathName))
		return FALSE;


	POSITION pos = GetFirstViewPosition();
	while (pos != NULL)
	{
		CChartViewerView* pView = (CChartViewerView *)GetNextView(pos);

		pView->Reinit();
	}

	return TRUE;
}


CChartData *CChartViewerDoc::GetDocumentDataPtr( void )
{
	return(&m_Data);
}
