namespace CodeMod
{
	using System;
	using System.Collections.Specialized;
	using Microsoft.Office.Core;
	using Extensibility;
	using System.Runtime.InteropServices;
	using EnvDTE;
	using Microsoft.VisualStudio.VCCodeModel;
	using System.IO;
	using System.Text;

	#region Read me for Add-in installation and setup information.
	// When run, the Add-in wizard prepared the registry for the Add-in.
	// At a later time, if the Add-in becomes unavailable for reasons such as:
	//   1) You moved this project to a computer other than which is was originally created on.
	//   2) You chose 'Yes' when presented with a message asking if you wish to remove the Add-in.
	//   3) Registry corruption.
	// you will need to re-register the Add-in by building the MyAddin21Setup project 
	// by right clicking the project in the Solution Explorer, then choosing install.
	#endregion
	
	/// <summary>
	///   The object for implementing an Add-in.
	/// </summary>
	/// <seealso class='IDTExtensibility2' />
	[GuidAttribute("E5F9D67B-A817-49EB-90E1-2BB959D64083"), ProgId("CodeMod.Connect")]
	public class Connect : Object, Extensibility.IDTExtensibility2, IDTCommandTarget
	{
		/// <summary>
		///		Implements the constructor for the Add-in object.
		///		Place your initialization code within this method.
		/// </summary>
		public Connect()
		{
		}

		/// <summary>
		///      Implements the OnConnection method of the IDTExtensibility2 interface.
		///      Receives notification that the Add-in is being loaded.
		/// </summary>
		/// <param term='application'>
		///      Root object of the host application.
		/// </param>
		/// <param term='connectMode'>
		///      Describes how the Add-in is being loaded.
		/// </param>
		/// <param term='addInInst'>
		///      Object representing this Add-in.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnConnection(object application, Extensibility.ext_ConnectMode connectMode, object addInInst, ref System.Array custom)
		{
			applicationObject = (_DTE)application;
			addInInstance = (AddIn)addInInst;
			if( connectMode == Extensibility.ext_ConnectMode.ext_cm_Startup
			|| connectMode == Extensibility.ext_ConnectMode.ext_cm_UISetup )
			{
				object []contextGUIDS = new object[] { };
				Commands commands = applicationObject.Commands;
				_CommandBars commandBars = applicationObject.CommandBars;

				// When run, the Add-in wizard prepared the registry for the Add-in.
				// At a later time, the Add-in or its commands may become unavailable for reasons such as:
				//   1) You moved this project to a computer other than which is was originally created on.
				//   2) You chose 'Yes' when presented with a message asking if you wish to remove the Add-in.
				//   3) You add new commands or modify commands already defined.
				// You will need to re-register the Add-in by building the CodeModSetup project,
				// right-clicking the project in the Solution Explorer, and then choosing install.
				// Alternatively, you could execute the ReCreateCommands.reg file the Add-in Wizard generated in
				// the project directory, or run 'devenv /setup' from a command prompt.
				try
				{
					Command command = commands.AddNamedCommand(addInInstance, "GenerateTypeInfo", "Generate TypeInfo", "Generates C++ TypeInfo objects for the current project", true, 59, ref contextGUIDS, (int)vsCommandStatus.vsCommandStatusSupported+(int)vsCommandStatus.vsCommandStatusEnabled);
					CommandBar commandBar = (CommandBar)commandBars["Tools"];
					CommandBarControl commandBarControl = command.AddControl(commandBar, 1);
				}
				catch(System.Exception /*e*/)
				{
				}
			}
			
		}

		/// <summary>
		///     Implements the OnDisconnection method of the IDTExtensibility2 interface.
		///     Receives notification that the Add-in is being unloaded.
		/// </summary>
		/// <param term='disconnectMode'>
		///      Describes how the Add-in is being unloaded.
		/// </param>
		/// <param term='custom'>
		///      Array of parameters that are host application specific.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnDisconnection(Extensibility.ext_DisconnectMode disconnectMode, ref System.Array custom)
		{
		}

		/// <summary>
		///      Implements the OnAddInsUpdate method of the IDTExtensibility2 interface.
		///      Receives notification that the collection of Add-ins has changed.
		/// </summary>
		/// <param term='custom'>
		///      Array of parameters that are host application specific.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnAddInsUpdate(ref System.Array custom)
		{
		}

		/// <summary>
		///      Implements the OnStartupComplete method of the IDTExtensibility2 interface.
		///      Receives notification that the host application has completed loading.
		/// </summary>
		/// <param term='custom'>
		///      Array of parameters that are host application specific.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnStartupComplete(ref System.Array custom)
		{
		}

		/// <summary>
		///      Implements the OnBeginShutdown method of the IDTExtensibility2 interface.
		///      Receives notification that the host application is being unloaded.
		/// </summary>
		/// <param term='custom'>
		///      Array of parameters that are host application specific.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnBeginShutdown(ref System.Array custom)
		{
		}
		
		/// <summary>
		///      Implements the QueryStatus method of the IDTCommandTarget interface.
		///      This is called when the command's availability is updated
		/// </summary>
		/// <param term='commandName'>
		///		The name of the command to determine state for.
		/// </param>
		/// <param term='neededText'>
		///		Text that is needed for the command.
		/// </param>
		/// <param term='status'>
		///		The state of the command in the user interface.
		/// </param>
		/// <param term='commandText'>
		///		Text requested by the neededText parameter.
		/// </param>
		/// <seealso class='Exec' />
		public void QueryStatus(string commandName, vsCommandStatusTextWanted neededText, ref vsCommandStatus status, ref object commandText)
		{
			if (neededText == vsCommandStatusTextWanted.vsCommandStatusTextWantedNone)
			{
				if (commandName == "CodeMod.Connect.GenerateTypeInfo")
				{
					status = (vsCommandStatus)vsCommandStatus.vsCommandStatusSupported|vsCommandStatus.vsCommandStatusEnabled;
				}
			}
		}

		/// <summary>
		///      Implements the Exec method of the IDTCommandTarget interface.
		///      This is called when the command is invoked.
		/// </summary>
		/// <param term='commandName'>
		///		The name of the command to execute.
		/// </param>
		/// <param term='executeOption'>
		///		Describes how the command should be run.
		/// </param>
		/// <param term='varIn'>
		///		Parameters passed from the caller to the command handler.
		/// </param>
		/// <param term='varOut'>
		///		Parameters passed from the command handler to the caller.
		/// </param>
		/// <param term='handled'>
		///		Informs the caller if the command was handled or not.
		/// </param>
		/// <seealso class='Exec' />
		public void Exec(string commandName, vsCommandExecOption executeOption, ref object varIn, ref object varOut, ref bool handled)
		{
			handled = false;
			if (executeOption == vsCommandExecOption.vsCommandExecOptionDoDefault)
			{
				if (commandName == "CodeMod.Connect.GenerateTypeInfo")
				{
					GenerateTypeInfo();
					handled = true;
					return;
				}
			}
		}

		public void GenerateTypeInfo()
		{
			// Get current solution.
			if (!applicationObject.Solution.IsOpen)
			{
				return;
			}
			Solution sln = applicationObject.Solution;

			// Create output file.
			FileInfo file = new FileInfo(sln.FileName);
			string outname = file.DirectoryName + "/AutoTypeInfo.h";
			writer = new StreamWriter(outname);

			processedTypes = new StringCollection();

			/*
			Find find = applicationObject.Find;

			// Where.
			find.Action = vsFindAction.vsFindActionFindAll;
			find.Target = vsFindTarget.vsFindTargetSolution;
			find.ResultsLocation = vsFindResultsLocation.vsFindResultsNone;
			find.SearchSubfolders = true;
			find.FilesOfType = "*.*";

			// What.
			find.FindWhat = "AUTO_STRUCT_INFO";
			find.MatchCase = true;
			find.MatchWholeWord = true;
			find.PatternSyntax = vsFindPatternSyntax.vsFindPatternSyntaxLiteral;

			vsFindResult result = find.Execute();
			*/

			// Count total code elements.
			logState.totalElems = 0;
			int p = 0;
			foreach (Project prj in sln.Projects)
			{
				VCCodeModel model = (VCCodeModel)prj.CodeModel;
				if (model != null)
				{
					applicationObject.StatusBar.Progress(true, "Updating code info for " + prj.Name, p, sln.Projects.Count);
					model.Synchronize();
					logState.totalElems += model.Structs.Count + model.Classes.Count + model.Namespaces.Count;
				}
				p++;
			}

			// Iterate solution projects, process all code elements.
			logState.totalElem = 0;
			logState.generatedTypes = 0;
			foreach (Project prj in sln.Projects)
			{
				/*
				writer.WriteLine("Project " + prj.Name);
				foreach (ProjectItem item in prj.ProjectItems)
				{
					writer.Write("  Item " + item.Name);
					if (item.Properties != null)
					{
						foreach (Property prop in item.Properties)
							writer.Write(" /" + prop.Name + "=" + prop.Value);
					}
					writer.WriteLine();
				}
				writer.Flush();
				*/
				VCCodeModel model = (VCCodeModel)prj.CodeModel;
				if (model != null)
				{
					logState.curProj = prj;
					logState.projElems = model.Structs.Count + model.Classes.Count + model.Namespaces.Count;
					logState.projElem = 0;
					ProcessList(model.Structs, true);
					ProcessList(model.Classes, true);
					ProcessList(model.Namespaces, true);
				}
			}
			applicationObject.StatusBar.Progress(false, "", 0, 0);
			writer.Close();
		}

		private void UpdateStatus()
		{
			if (System.DateTime.Now.Ticks > logState.lastLogTicks + 100000)
			{
				applicationObject.StatusBar.Progress(true, 
					"Searching types in " + logState.curProj.Name 
					+ " (" + 100*logState.projElem/logState.projElems + "%), generated " 
					+ logState.generatedTypes + " types", 
					logState.totalElem, logState.totalElems);
				logState.lastLogTicks = System.DateTime.Now.Ticks;
			}
		}

		private void ProcessList(CodeElements list, bool bUpdateLog)
		{
			foreach (VCCodeElement elem in list)
			{
				if (bUpdateLog)
				{
					UpdateStatus();
					logState.projElem++;
					logState.totalElem++;
				}
				Process((VCCodeElement)elem);
			}
		}

		private void Process(VCCodeElement elem)
		{
			if (elem.Kind == vsCMElement.vsCMElementNamespace)
			{
				VCCodeNamespace type = (VCCodeNamespace)elem;

				// Recurse.
				ProcessList(type.Structs, false);
				ProcessList(type.Classes, false);
				ProcessList(type.Namespaces, false);
			}
			else if (elem.Kind == vsCMElement.vsCMElementStruct
			|| elem.Kind == vsCMElement.vsCMElementClass)
			{
				if (!elem.IsInjected && !elem.IsReadOnly)
				{
					if (elem.Comment.IndexOf("$TypeInfo") >= 0)
						ProcessStruct((CodeType)elem);
					else
					{
						EditPoint edit = elem.StartPoint.CreateEditPoint();
						string text = edit.GetText(elem.EndPoint);
						if (CheckText(text))
							ProcessStruct((CodeType)elem);
					}

					// Recurse.
					if (elem.Kind == vsCMElement.vsCMElementStruct)
					{
						ProcessList(((VCCodeStruct)elem).Structs, false);
						ProcessList(((VCCodeStruct)elem).Classes, false);
					}
					else if (elem.Kind == vsCMElement.vsCMElementClass)
					{
						ProcessList(((VCCodeClass)elem).Structs, false);
						ProcessList(((VCCodeClass)elem).Classes, false);
					}
				}
			}
			else if (elem.Kind == vsCMElement.vsCMElementEnum)
			{
				if (elem.Comment.IndexOf("$TypeInfo") >= 0)
					ProcessEnum((VCCodeEnum)elem);
			}
		}

		bool CheckText(string body)
		{
			int pos = body.IndexOf("AUTO_STRUCT_INFO");
			if (pos >= 0)
			{
				// Make sure it's in the outer scope.
				int scope = 0;
				for (int p = 0; (p = body.IndexOf('{', p, pos-p)) >= 0; p++)
					scope++;
				for (int p = 0; (p = body.IndexOf('}', p, pos-p)) >= 0; p++)
					scope--;
				return scope == 1;
			}
			return false;
		}

		// Generate type info for structs.
		private void ProcessStruct(CodeType struc)
		{
			if (processedTypes.Contains(struc.FullName))
				return;
			processedTypes.Add(struc.FullName);

			// Extract template declarations.
			string strucMacroString = "STRUCT_INFO";
			string strucNameString = struc.FullName;
			bool bTemplate = false;
			if (struc.Kind == vsCMElement.vsCMElementStruct)
				bTemplate = ((VCCodeStruct)struc).IsTemplate;
			else if (struc.Kind == vsCMElement.vsCMElementClass)
				bTemplate = ((VCCodeClass)struc).IsTemplate;
			if (bTemplate)
			{
				int tpos = struc.FullName.IndexOf('<');
				if (tpos > 0)
				{
					strucMacroString = "TEMPLATE_STRUCT_INFO";
					strucNameString = strucNameString.Insert(tpos, ", ");
					string declArgs = "";
					if (struc.Kind == vsCMElement.vsCMElementStruct)
						declArgs = ((VCCodeStruct)struc).DeclarationText;
					else if (struc.Kind == vsCMElement.vsCMElementClass)
						declArgs = ((VCCodeClass)struc).DeclarationText;
					tpos = declArgs.IndexOf('<');
					int etpos = declArgs.LastIndexOf('>');
					strucNameString += ", " + declArgs.Substring(tpos, etpos+1-tpos);
				}
			}

			// See whether there are any members.
			int varCount = 0;
			foreach (CodeElement member in struc.Members)
			{
				if (member.Kind == vsCMElement.vsCMElementVariable)
				{
					CodeVariable var = (CodeVariable)member;
					if (!var.IsShared)
					{
						varCount++;

						// Auto-generate enum infos.
						if (var.Type.TypeKind == vsCMTypeRef.vsCMTypeRefCodeType && var.Type.CodeType.Kind == vsCMElement.vsCMElementEnum)
						{
							if (!processedTypes.Contains(var.Type.AsFullName))
							{
								processedTypes.Add(var.Type.AsFullName);
								writer.WriteLine("STRUCT_INFO_BASIC(" + var.Type.AsFullName + ")");
								writer.WriteLine();
								logState.generatedTypes++;
							}
						}
					}
				}
			}

			if (varCount == 0 && struc.Bases.Count == 0)
			{
				writer.WriteLine(strucMacroString + "_EMPTY(" + strucNameString + ")");
				writer.WriteLine();
				return;
			}

			writer.WriteLine(strucMacroString + "_BEGIN(" + strucNameString+ ")");

			// Bases.
			foreach (CodeElement base_ in struc.Bases)
			{
				writer.WriteLine( "\tSTRUCT_BASE_INFO(" + base_.FullName + ")" );
			}

			// Non-static variable members.
			foreach (CodeElement member in struc.Members)
			{
				if (member.Kind == vsCMElement.vsCMElementVariable)
				{
					CodeVariable var = (CodeVariable)member;
					if (!var.IsShared)
					{
						// Decompose additional type info into a text string.
						// Deficient code model doesn't have full type info, we must resort to text parsing.
						string typeName = var.Type.AsString;
						string typeInfo = "@";			// Placeholder for final type name, to simplify text manipulation.

						// Decompose outside in.
						for (;;)
						{
							int pos;

							// To do: Nesting: int (*) [4].

							// Array.
							pos = typeName.IndexOf('[');
							int lpos = typeName.IndexOf(']');
							if (pos > 0 && lpos > pos)
							{
								string dim = typeName.Substring(pos+1, lpos-pos-1).Trim();
								typeInfo = typeInfo.Replace("@", "TYPE_ARRAY(" + dim + ", @)");
								typeName = typeName.Remove(pos, lpos+1-pos);
								continue;
							}

							// Pointer.
							pos = typeName.LastIndexOf('*');
							if (pos > 0)
							{
								typeInfo = typeInfo.Replace("@", "TYPE_POINTER(@)");
								typeName = typeName.Remove(pos, 1);
								continue;
							}

							pos = typeName.LastIndexOf('&');
							if (pos > 0)
							{
								typeInfo = typeInfo.Replace("@", "TYPE_REFERENCE(@)");
								typeName = typeName.Remove(pos, 1);
								continue;
							}

							break;
						}

						// Bitfield.
						int fpos = typeName.IndexOf(':');
						if (fpos > 0 && typeName[fpos+1] != ':')
						{
							string bits = typeName.Substring(fpos+1).Trim();
							typeName = typeName.Substring(0, fpos);
							writer.WriteLine("\tSTRUCT_BITFIELD_INFO(" + var.Name + ", " + typeName.Trim() + ", " + bits + ")" );
						}
						else
						{
							typeInfo = typeInfo.Replace("@", "TYPE_INFO(" + typeName.Trim() + ")");
							writer.WriteLine( "\tSTRUCT_VAR_INFO(" + var.Name + ", " + typeInfo + ")" );
						}
					}
				}
			}

			writer.WriteLine( strucMacroString + "_END(" + strucNameString + ")" );
			writer.WriteLine();
			logState.generatedTypes++;
			UpdateStatus();
		}

		private void ProcessEnum(VCCodeEnum enu)
		{
			writer.WriteLine("ENUM_INFO_BEGIN(" + enu.FullName + ")");
			foreach (VCCodeElement elem in enu.Members)
			{
				writer.WriteLine("\tENUM_MEMBER(" + enu.FullName + ", " + elem.Name + ")");
			}
			writer.WriteLine("ENUM_INFO_END(" + enu.FullName + ")");
			writer.WriteLine();
			logState.generatedTypes++;
			UpdateStatus();
		}

		private _DTE applicationObject;
		private AddIn addInInstance;
		StreamWriter writer;

		StringCollection processedTypes;
		
		// Logging state
		struct LogState
		{
			public Project curProj;
			public int projElem, projElems;
			public int totalElem, totalElems;
			public int generatedTypes;
			public long lastLogTicks;
		};
		LogState logState;
	}
}