#include "StdAfx.h"
#include "AnimationData.h"

AnimationData::AnimationData(int modelCount)
: m_entries(modelCount),
	m_frameCount(0)
{
}

void AnimationData::SetFrameData(int modelIndex, int frameIndex, float translation[3], float rotation[3], float scale[3])
{
	State& state = m_entries[modelIndex].samples[frameIndex];
	state.translation[0] = translation[0]; state.translation[1] = translation[1]; state.translation[2] = translation[2];
	state.rotation[0] = rotation[0]; state.rotation[1] = rotation[1]; state.rotation[2] = rotation[2];
	state.scale[0] = scale[0]; state.scale[1] = scale[1]; state.scale[2] = scale[2];
}

void AnimationData::SetFrameCount(int frameCount)
{
	m_frameCount = frameCount;
	for (int modelIndex = 0, modelCount = int(m_entries.size()); modelIndex < modelCount; ++modelIndex)
	{
		m_entries[modelIndex].samples.resize(frameCount);
	}
}

void AnimationData::SetModelFlags(int modelIndex, unsigned modelFlags)
{
	m_entries[modelIndex].flags = modelFlags;
}

void AnimationData::GetState(int modelIndex, int frameIndex, const float*& translation, const float*& rotation, const float*& scale) const
{
	translation = m_entries[modelIndex].samples[frameIndex].translation;
	rotation = m_entries[modelIndex].samples[frameIndex].rotation;
	scale = m_entries[modelIndex].samples[frameIndex].scale;
}

int AnimationData::GetFrameCount() const
{
	return m_frameCount;
}

unsigned AnimationData::GetModelFlags(int modelIndex)
{
	return m_entries[modelIndex].flags;
}

AnimationData::State::State()
{
	translation[0] = translation[1] = translation[2] = 0.0f;
	rotation[0] = rotation[1] = rotation[2] = 0.0f;
	scale[0] = scale[1] = scale[2] = 1.0f;
}

AnimationData::ModelEntry::ModelEntry()
: flags(0)
{
}
