#ifndef __ANIMATIONDATA_H__
#define __ANIMATIONDATA_H__

#include "IAnimationData.h"

#include <vector>

class AnimationData : public IAnimationData
{
public:
	AnimationData(int modelCount);

	// IAnimationData
	virtual void SetFrameData(int modelIndex, int frameIndex, float translation[3], float rotation[3], float scale[3]);
	virtual void SetFrameCount(int frameCount);
	virtual void SetModelFlags(int modelIndex, unsigned modelFlags);

	void GetState(int modelIndex, int frameIndex, const float*& translation, const float*& rotation, const float*& scale) const;
	int GetFrameCount() const;
	unsigned GetModelFlags(int modelIndex);

private:
	struct State
	{
	public:
		State();
		float translation[3];
		float rotation[3];
		float scale[3];
	};

	struct ModelEntry
	{
		ModelEntry();

		unsigned flags;
		std::vector<State> samples;
	};

	std::vector<ModelEntry> m_entries;
	int m_frameCount;
};

#endif //__ANIMATIONDATA_H__
