#include "StdAfx.h"
#include "ExportSourceDecoratorBase.h"

ExportSourceDecoratorBase::ExportSourceDecoratorBase(IExportSource* source)
: source(source)
{
}

int ExportSourceDecoratorBase::GetFileName(char* buffer, int bufferSize) const
{
	return this->source->GetFileName(buffer, bufferSize);
}

void ExportSourceDecoratorBase::ReadGeometryFiles(IExportContext* context, IGeometryFileData* geometryFileData)
{
	this->source->ReadGeometryFiles(context, geometryFileData);
}

void ExportSourceDecoratorBase::ReadMaterials(IGeometryFileData* geometryFileData, IMaterialData* materialData)
{
	this->source->ReadMaterials(geometryFileData, materialData);
}

void ExportSourceDecoratorBase::ReadModels(IGeometryFileData* geometryFileData, IMaterialData* materialData, IModelData* modelData, int geometryFileIndex)
{
	this->source->ReadModels(geometryFileData, materialData, modelData, geometryFileIndex);
}

void ExportSourceDecoratorBase::ReadSkinning(IExportContext* context, ISkinningData* skinningData, IModelData* modelData, int modelIndex, ISkeletonData* skeletonData)
{
	this->source->ReadSkinning(context, skinningData, modelData, modelIndex, skeletonData);
}

bool ExportSourceDecoratorBase::ReadSkeleton(IGeometryFileData* geometryFileData, int geometryFileIndex, IModelData* modelData, int modelIndex, const IMaterialData* materialData, ISkeletonData* skeletonData)
{
	return this->source->ReadSkeleton(geometryFileData, geometryFileIndex, modelData, modelIndex, materialData, skeletonData);
}

int ExportSourceDecoratorBase::GetAnimationCount() const
{
	return this->source->GetAnimationCount();
}

int ExportSourceDecoratorBase::GetAnimationName(char* buffer, int bufferSize, IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex) const
{
	return this->GetAnimationName(buffer, bufferSize, geometryFileData, geometryFileIndex, animationIndex);
}

void ExportSourceDecoratorBase::GetAnimationTimeSpan(float& start, float& stop, int animationIndex) const
{
	this->GetAnimationTimeSpan(start, stop, animationIndex);
}

void ExportSourceDecoratorBase::ReadAnimationFlags(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex) const
{
	this->source->ReadAnimationFlags(context, animationData, geometryFileData, modelData, modelIndex, skeletonData, animationIndex);
}

void ExportSourceDecoratorBase::ReadAnimation(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex, float fps) const
{
	this->source->ReadAnimation(context, animationData, geometryFileData, modelData, modelIndex, skeletonData, animationIndex, fps);
}

bool ExportSourceDecoratorBase::ReadGeometry(IExportContext* context, IGeometryData* geometry, IModelData* modelData, IMaterialData* materialData, int modelIndex) const
{
	return this->source->ReadGeometry(context, geometry, modelData, materialData, modelIndex);
}

bool ExportSourceDecoratorBase::ReadBoneGeometry(IExportContext* context, IGeometryData* geometry, ISkeletonData* skeletonData, int boneIndex, IMaterialData* materialData) const
{
	return this->source->ReadBoneGeometry(context, geometry, skeletonData, boneIndex, materialData);
}
