#ifndef __EXPORTSOURCEDECORATORBASE_H__
#define __EXPORTSOURCEDECORATORBASE_H__

#include "IExportSource.h"

class ExportSourceDecoratorBase : public IExportSource
{
public:
	ExportSourceDecoratorBase(IExportSource* source);

	virtual int GetFileName(char* buffer, int bufferSize) const;
	virtual void ReadGeometryFiles(IExportContext* context, IGeometryFileData* geometryFileData);
	virtual void ReadMaterials(IGeometryFileData* geometryFileData, IMaterialData* materialData);
	virtual void ReadModels(IGeometryFileData* geometryFileData, IMaterialData* materialData, IModelData* modelData, int geometryFileIndex);
	virtual void ReadSkinning(IExportContext* context, ISkinningData* skinningData, IModelData* modelData, int modelIndex, ISkeletonData* skeletonData);
	virtual bool ReadSkeleton(IGeometryFileData* geometryFileData, int geometryFileIndex, IModelData* modelData, int modelIndex, const IMaterialData* materialData, ISkeletonData* skeletonData);
	virtual int GetAnimationCount() const;
	virtual int GetAnimationName(char* buffer, int bufferSize, IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex) const;
	virtual void GetAnimationTimeSpan(float& start, float& stop, int animationIndex) const;
	virtual void ReadAnimationFlags(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex) const;
	virtual void ReadAnimation(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex, float fps) const;
	virtual bool ReadGeometry(IExportContext* context, IGeometryData* geometry, IModelData* modelData, IMaterialData* materialData, int modelIndex) const;
	virtual bool ReadBoneGeometry(IExportContext* context, IGeometryData* geometry, ISkeletonData* skeletonData, int boneIndex, IMaterialData* materialData) const;

protected:
	IExportSource* source;
};

#endif //__EXPORTSOURCEDECORATORBASE_H__
