#include "GeometryExportSourceAdapater.h"
#include "IGeometryFileData.h"
#include <cassert>

GeometryExportSourceAdapater::GeometryExportSourceAdapater(IExportSource* source, IGeometryFileData* geometryFileData, int geometryFileIndex)
: ExportSourceDecoratorBase(source), geometryFileData(geometryFileData), geometryFileIndex(geometryFileIndex)
{
}

void GeometryExportSourceAdapater::ReadGeometryFiles(IExportContext* context, IGeometryFileData* geometryFileData)
{
	int geometryFileIndex = geometryFileData->AddGeometryFile(
		this->geometryFileData->GetGeometryFileHandle(this->geometryFileIndex),
		this->geometryFileData->GetGeometryFileName(this->geometryFileIndex),
		this->geometryFileData->GetContentType(this->geometryFileIndex),
		this->geometryFileData->GetFilename(this->geometryFileIndex),
		this->geometryFileData->GetExportSetting(this->geometryFileIndex),
		this->geometryFileData->GetMergeSetting(this->geometryFileIndex));
		
	for (int propertyIndex = 0, propertyCount = this->geometryFileData->GetPropertyCount(this->geometryFileIndex); propertyIndex < propertyCount; ++propertyIndex)
	{
		std::pair<std::string, std::string> property = GetProperty(this->geometryFileData, this->geometryFileIndex, propertyIndex);
		geometryFileData->SetProperty(geometryFileIndex, property.first.c_str(), property.second.c_str());
	}
}

void GeometryExportSourceAdapater::ReadModels(IGeometryFileData* geometryFileData, IMaterialData* materialData, IModelData* modelData, int geometryFileIndex)
{
	assert(geometryFileIndex == 0);
	this->source->ReadModels(this->geometryFileData, materialData, modelData, this->geometryFileIndex);
}

bool GeometryExportSourceAdapater::ReadSkeleton(IGeometryFileData* geometryFileData, int geometryFileIndex, IModelData* modelData, int modelIndex, const IMaterialData* materialData, ISkeletonData* skeletonData)
{
	assert(geometryFileIndex == 0);
	return this->source->ReadSkeleton(this->geometryFileData, this->geometryFileIndex, modelData, modelIndex, materialData, skeletonData);
}

int GeometryExportSourceAdapater::GetAnimationCount() const
{
	return 0;
}

int GeometryExportSourceAdapater::GetAnimationName(char* buffer, int bufferSize, IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex) const
{
	assert(0);
	return 0;
}

void GeometryExportSourceAdapater::GetAnimationTimeSpan(float& start, float& stop, int animationIndex) const
{
	assert(0);
	start = stop = 0.0f;
}

void GeometryExportSourceAdapater::ReadAnimationFlags(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex) const
{
	assert(0);
}

void GeometryExportSourceAdapater::ReadAnimation(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex, float fps) const
{
	assert(0);
}
