#ifndef __GEOMETRYEXPORTSOURCEADAPTER_H__
#define __GEOMETRYEXPORTSOURCEADAPTER_H__

#include "ExportSourceDecoratorBase.h"

class GeometryExportSourceAdapater : public ExportSourceDecoratorBase
{
public:
	GeometryExportSourceAdapater(IExportSource* source, IGeometryFileData* geometryFileData, int geometryFileIndex);

	virtual void ReadGeometryFiles(IExportContext* context, IGeometryFileData* geometryFileData);
	virtual void ReadModels(IGeometryFileData* geometryFileData, IMaterialData* materialData, IModelData* modelData, int geometryFileIndex);
	virtual bool ReadSkeleton(IGeometryFileData* geometryFileData, int geometryFileIndex, IModelData* modelData, int modelIndex, const IMaterialData* materialData, ISkeletonData* skeletonData);
	virtual int GetAnimationCount() const;
	virtual int GetAnimationName(char* buffer, int bufferSize, IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex) const;
	virtual void GetAnimationTimeSpan(float& start, float& stop, int animationIndex) const;
	virtual void ReadAnimationFlags(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex) const;
	virtual void ReadAnimation(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex, float fps) const;

private:
	IGeometryFileData* geometryFileData;
	int geometryFileIndex;
};

#endif //__GEOMETRYEXPORTSOURCEADAPTER_H__
