#include "StdAfx.h"
#include "GeometryFileData.h"

int GeometryFileData::AddGeometryFile(void* handle, const char* name, ContentType contentType, const char* filename, ExportSetting exportSetting, MergeSetting mergeSetting)
{
	int geometryFileIndex = int(m_geometryFiles.size());
	m_geometryFiles.push_back(GeometryFileEntry(handle, name, contentType, filename, exportSetting, mergeSetting));
	m_nameGeometryFileMap.insert(std::make_pair(name, geometryFileIndex));
	return geometryFileIndex;
}

int GeometryFileData::FindGeometryFile(const char* geometryFileName)
{
	NameGeometryFileMap::iterator namePos = m_nameGeometryFileMap.find(geometryFileName);
	return (namePos != m_nameGeometryFileMap.end() ? (*namePos).second : -1);
}

int GeometryFileData::GetGeometryFileCount() const
{
	return int(m_geometryFiles.size());
}

void* GeometryFileData::GetGeometryFileHandle(int geometryFileIndex) const
{
	return m_geometryFiles[geometryFileIndex].handle;
}

const char* GeometryFileData::GetGeometryFileName(int geometryFileIndex) const
{
	return m_geometryFiles[geometryFileIndex].name.c_str();
}

IGeometryFileData::ContentType GeometryFileData::GetContentType(int geometryFileIndex) const
{
	return m_geometryFiles[geometryFileIndex].contentType;
}

const char* GeometryFileData::GetFilename(int geometryFileIndex) const
{
	return m_geometryFiles[geometryFileIndex].filename.c_str();
}

IGeometryFileData::ExportSetting GeometryFileData::GetExportSetting(int geometryFileIndex) const
{
	return m_geometryFiles[geometryFileIndex].exportSetting;
}

IGeometryFileData::MergeSetting GeometryFileData::GetMergeSetting(int geometryFileIndex) const
{
	return m_geometryFiles[geometryFileIndex].mergeSetting;
}

void GeometryFileData::SetProperty(int geometryFileIndex, const char* key, const char* value)
{
	GeometryFileEntry& model = m_geometryFiles[geometryFileIndex];

	GeometryFileEntry::KeyPropertyMap::iterator keyPos = model.keyPropertyMap.find(key);
	if (keyPos == model.keyPropertyMap.end())
	{
		int valueIndex = int(model.properties.size());
		model.properties.push_back(std::make_pair(key, std::string()));
		keyPos = model.keyPropertyMap.insert(std::make_pair(key, valueIndex)).first;
	}

	model.properties[(*keyPos).second].second = value;
}

int GeometryFileData::GetPropertyCount(int geometryFileIndex) const
{
	return int(m_geometryFiles[geometryFileIndex].properties.size());
}

void GeometryFileData::GetProperty(int geometryFileIndex, int propertyIndex, char* keyBuffer, int keyBufferSize, char* valueBuffer, int valueBufferSize) const
{
	const GeometryFileEntry& model = m_geometryFiles[geometryFileIndex];
	strncpy(keyBuffer, model.properties[propertyIndex].first.c_str(), keyBufferSize);
	if (keyBufferSize > 0)
		keyBuffer[keyBufferSize - 1] = 0;
	strncpy(valueBuffer, model.properties[propertyIndex].second.c_str(), valueBufferSize);
	if (valueBufferSize > 0)
		valueBuffer[valueBufferSize - 1] = 0;
}

std::string GeometryFileData::GetPropertyValue(int geometryFileIndex, const std::string& key)
{
	GeometryFileEntry& model = m_geometryFiles[geometryFileIndex];

	GeometryFileEntry::KeyPropertyMap::iterator keyPos = model.keyPropertyMap.find(key);
	std::string value;
	if (keyPos != model.keyPropertyMap.end())
		value = model.properties[(*keyPos).second].second;
	return value;
}

GeometryFileData::GeometryFileEntry::GeometryFileEntry(void* handle, const char* name, ContentType contentType, const char* filename, ExportSetting exportSetting, MergeSetting mergeSetting)
: handle(handle), name(name), contentType(contentType), filename(filename), exportSetting(exportSetting), mergeSetting(mergeSetting)
{
}
