#ifndef __GEOMETRYFILEDATA_H__
#define __GEOMETRYFILEDATA_H__

#include "IGeometryFileData.h"
#include "STLHelpers.h"

class GeometryFileData : public IGeometryFileData
{
public:
	// IGeometryFileData
	virtual int AddGeometryFile(void* handle, const char* name, ContentType contentType, const char* filename, ExportSetting exportSetting, MergeSetting mergeSetting);
	virtual int FindGeometryFile(const char* geometryFileName);
	virtual int GetGeometryFileCount() const;
	virtual void* GetGeometryFileHandle(int geometryFileIndex) const;
	virtual const char* GetGeometryFileName(int geometryFileIndex) const;
	virtual ContentType GetContentType(int geometryFileIndex) const;
	virtual const char* GetFilename(int geometryFileIndex) const;
	virtual ExportSetting GetExportSetting(int geometryFileIndex) const;
	virtual MergeSetting GetMergeSetting(int geometryFileIndex) const;
	virtual void SetProperty(int geometryFileIndex, const char* key, const char* value);
	virtual int GetPropertyCount(int geometryFileIndex) const;
	virtual void GetProperty(int geometryFileIndex, int propertyIndex, char* keyBuffer, int keyBufferSize, char* valueBuffer, int valueBufferSize) const;

	std::string GetPropertyValue(int geometryFileIndex, const std::string& key);

private:
	struct GeometryFileEntry
	{
		GeometryFileEntry(void* handle, const char* name, ContentType contentType, const char* filename, ExportSetting exportSetting, MergeSetting mergeSetting);

		void* handle;
		std::string name;
		ContentType contentType;
		std::string filename;
		ExportSetting exportSetting;
		MergeSetting mergeSetting;
		std::vector<std::pair<std::string, std::string> > properties;
		typedef std::map<std::string, int, STLHelpers::less_stricmp<std::string> > KeyPropertyMap;
		KeyPropertyMap keyPropertyMap;
	};

	std::vector<GeometryFileEntry> m_geometryFiles;
	typedef std::map<std::string, int, STLHelpers::less_stricmp<std::string> > NameGeometryFileMap;
	NameGeometryFileMap m_nameGeometryFileMap;
};

#endif //__GEOMETRYFILEDATA_H__
