#ifndef __IEXPORTER_H__
#define __IEXPORTER_H__

#include "Exceptions.h"

class IExportWriter;
class IExportSource;
class IExportContext;

class IExporter
{
public:
	// Declare an exception type to report the case where the scene must be saved before exporting.
	struct NeedSaveErrorTag {};
	typedef Exception<NeedSaveErrorTag> NeedSaveError;
	struct PakSystemErrorTag {};
	typedef Exception<PakSystemErrorTag> PakSystemError;

	virtual void SetWriter(IExportWriter* writer) = 0;
	virtual void SetSource(IExportSource* source) = 0;
	virtual void Export(IExportContext* context) = 0;
};

#endif //__IEXPORTER_H__
