#ifndef __IGEOMETRYDATA_H__
#define __IGEOMETRYDATA_H__

class IGeometryData
{
public:
	enum VertexFlags
	{
		VertexFlags_Normal = 1,
		VertexFlags_TextureCoordinate = 2,
		VertexFlags_VertexColour = 4
	};

	virtual void SetVertexFlags(unsigned flags) = 0;
	virtual int AddPosition(float x, float y, float z) = 0;
	virtual int AddNormal(float x, float y, float z) = 0;
	virtual int AddTextureCoordinate(float u, float v) = 0;
	virtual int AddVertexColour(float r, float g, float b, float a) = 0;

	virtual int AddPolygon(const int* indices, int mtlID) = 0;
};

#endif //__IGEOMETRYDATA_H__
