#ifndef __IGEOMETRYFILE_H__
#define __IGEOMETRYFILE_H__

class IGeometryFileData
{
public:
	enum ContentType
	{
		ContentType_CGF,
		ContentType_CGA,
		ContentType_ANM,
		ContentType_CGAANM,
		ContentType_CHR,
		ContentType_CAF,
		ContentType_CHRCAF
	};

	enum MergeSetting
	{
		MergeSetting_NoMerge,
		MergeSetting_Merge
	};

	enum ExportSetting
	{
		ExportSetting_NoExport,
		ExportSetting_Export
	};

	virtual int AddGeometryFile(void* handle, const char* name, ContentType contentType, const char* filename, ExportSetting exportSetting, MergeSetting mergeSetting) = 0;
	virtual int FindGeometryFile(const char* geometryFileName) = 0;
	virtual int GetGeometryFileCount() const = 0;
	virtual void* GetGeometryFileHandle(int geometryFileIndex) const = 0;
	virtual const char* GetGeometryFileName(int geometryFileIndex) const = 0;
	virtual ContentType GetContentType(int geometryFileIndex) const = 0;
	virtual const char* GetFilename(int geometryFileIndex) const = 0;
	virtual ExportSetting GetExportSetting(int geometryFileIndex) const = 0;
	virtual MergeSetting GetMergeSetting(int geometryFileIndex) const = 0;
	virtual void SetProperty(int geometryFileIndex, const char* key, const char* value) = 0;
	virtual int GetPropertyCount(int geometryFileIndex) const = 0;
	virtual void GetProperty(int geometryFileIndex, int propertyIndex, char* keyBuffer, int keyBufferSize, char* valueBuffer, int valueBufferSize) const = 0;
};

inline std::pair<std::string, std::string> GetProperty(IGeometryFileData* geometryFileData, int geometryFileIndex, int propertyIndex)
{
	char keyBuffer[1024];
	char valueBuffer[1024];
	geometryFileData->GetProperty(geometryFileIndex, propertyIndex, keyBuffer, sizeof(keyBuffer) / sizeof(keyBuffer[0]), valueBuffer, sizeof(valueBuffer) / sizeof(valueBuffer[0]));
	return std::make_pair(keyBuffer, valueBuffer);
}

#endif //__IGEOMETRYFILE_H__
