#ifndef __IMATERIALDATA_H__
#define __IMATERIALDATA_H__

class IMaterialData
{
public:
	virtual int AddMaterial(const char* name, int id, int parentIndex, void* handle) = 0;
	virtual int LookupMaterial(void* handle) const = 0;
	virtual int GetMaterialCount() const = 0;
	virtual const char* GetName(int materialIndex) const = 0;
	virtual int GetID(int materialIndex) const = 0;
	virtual int GetParentIndex(int materialIndex) const = 0;
	virtual void* GetHandle(int materialIndex) const = 0;
};

#endif //__IMATERIALDATA_H__
