#ifndef __IMODELDATA_H__
#define __IMODELDATA_H__

class IModelData
{
public:
	virtual int AddModel(void* handle, const char* modelName, int parentIndex, bool geometry, int materialIndex) = 0;
	virtual int GetModelCount() const = 0;
	virtual void* GetModelHandle(int modelIndex) const = 0;
	virtual const char* GetModelName(int modelIndex) const = 0;
	virtual void SetTranslation(int boneIndex, const float* vec) = 0;
	virtual void SetRotation(int boneIndex, const float* vec) = 0;
	virtual void SetScale(int boneIndex, const float* vec) = 0;
};

#endif //__IMODELDATA_H__
