#include "StdAfx.h"
#include "MaterialData.h"

int MaterialData::AddMaterial(const char* name, int id, int parentIndex, void* handle)
{
	int materialIndex = int(m_materials.size());
	m_materials.push_back(MaterialEntry(name, id, parentIndex, handle));
	m_handleIndexMap.insert(std::make_pair(handle, materialIndex));
	return materialIndex;
}

int MaterialData::LookupMaterial(void* handle) const
{
	std::map<void*, int>::const_iterator handleMapPos = m_handleIndexMap.find(handle);
	int materialIndex = (handleMapPos != m_handleIndexMap.end() ? (*handleMapPos).second : -1);
	return materialIndex;
}

int MaterialData::GetMaterialCount() const
{
	return int(m_materials.size());
}

const char* MaterialData::GetName(int materialIndex) const
{
	assert(materialIndex >= 0);
	assert(materialIndex < int(m_materials.size()));
	return m_materials[materialIndex].name.c_str();
}

int MaterialData::GetID(int materialIndex) const
{
	assert(materialIndex >= 0);
	assert(materialIndex < int(m_materials.size()));
	return m_materials[materialIndex].id;
}

int MaterialData::GetParentIndex(int materialIndex) const
{
	assert(materialIndex >= 0);
	assert(materialIndex < int(m_materials.size()));
	return m_materials[materialIndex].parentIndex;
}

void* MaterialData::GetHandle(int materialIndex) const
{
	assert(materialIndex >= 0);
	assert(materialIndex < int(m_materials.size()));
	return m_materials[materialIndex].handle;
}
