#ifndef __MATERIALDATA_H__
#define __MATERIALDATA_H__

#include "IMaterialData.h"

class MaterialData : public IMaterialData
{
public:
	virtual int AddMaterial(const char* name, int id, int parentIndex, void* handle);
	virtual int LookupMaterial(void* handle) const;
	virtual int GetMaterialCount() const;
	virtual const char* GetName(int materialIndex) const;
	virtual int GetID(int materialIndex) const;
	virtual int GetParentIndex(int materialIndex) const;
	virtual void* GetHandle(int materialIndex) const;

private:
	struct MaterialEntry
	{
		explicit MaterialEntry(const char* name, int id, int parentIndex, void* handle)
			: name(name), id(id), parentIndex(parentIndex), handle(handle) {}
		string name;
		int id;
		int parentIndex;
		void* handle;
	};

	std::vector<MaterialEntry> m_materials;
	std::map<void*, int> m_handleIndexMap;
};

#endif //__MATERIALDATA_H__
