#include "StdAfx.h"
#include "ModelData.h"

int ModelData::AddModel(void* handle, const char* modelName, int parentIndex, bool geometry, int materialIndex)
{
	int modelIndex = int(m_models.size());
	m_models.push_back(ModelEntry(handle, modelName, parentIndex, geometry, materialIndex));
	if (parentIndex >= 0)
		m_models[parentIndex].children.push_back(modelIndex);
	else
		m_roots.push_back(modelIndex);
	return modelIndex;
}

void* ModelData::GetModelHandle(int modelIndex) const
{
	return m_models[modelIndex].handle;
}

const char* ModelData::GetModelName(int modelIndex) const
{
	return m_models[modelIndex].name.c_str();
}

void ModelData::SetTranslation(int modelIndex, const float* vec)
{
	for (int i = 0; i < 3; ++i)
		m_models[modelIndex].translation[i] = vec[i];
}

void ModelData::SetRotation(int modelIndex, const float* vec)
{
	for (int i = 0; i < 3; ++i)
		m_models[modelIndex].rotation[i] = vec[i];
}

void ModelData::SetScale(int modelIndex, const float* vec)
{
	for (int i = 0; i < 3; ++i)
		m_models[modelIndex].scale[i] = vec[i];
}

int ModelData::GetModelCount() const
{
	return int(m_models.size());
}

int ModelData::GetRootCount() const
{
	return int(m_roots.size());
}

int ModelData::GetRootIndex(int rootIndex) const
{
	return m_roots[rootIndex];
}

int ModelData::GetChildCount(int modelIndex) const
{
	return int(m_models[modelIndex].children.size());
}

int ModelData::GetChildIndex(int modelIndex, int childIndexIndex) const
{
	return m_models[modelIndex].children[childIndexIndex];
}

void ModelData::GetTranslation(float* vec, int modelIndex) const
{
	for (int i = 0; i < 3; ++i)
		vec[i] = m_models[modelIndex].translation[i];
}

void ModelData::GetRotation(float* vec, int modelIndex) const
{
	for (int i = 0; i < 3; ++i)
		vec[i] = m_models[modelIndex].rotation[i];
}

void ModelData::GetScale(float* vec, int modelIndex) const
{
	for (int i = 0; i < 3; ++i)
		vec[i] = m_models[modelIndex].scale[i];
}

bool ModelData::HasGeometry(int modelIndex) const
{
	return m_models[modelIndex].geometry;
}

int ModelData::GetMaterialIndex(int modelIndex) const
{
	return m_models[modelIndex].materialIndex;
}

ModelData::ModelEntry::ModelEntry(void* handle, const std::string& name, int parentIndex, bool geometry, int materialIndex)
: handle(handle), name(name), parentIndex(parentIndex), geometry(geometry), materialIndex(materialIndex)
{
	translation[0] = translation[1] = translation[2] = 0.0f;
	rotation[0] = rotation[1] = rotation[2] = 0.0f;
	scale[0] = scale[1] = scale[2] = 1.0f;
}
