#ifndef __MODELDATA_H__
#define __MODELDATA_H__

#include "IModelData.h"

class ModelData : public IModelData
{
public:
	// IModelData
	virtual int AddModel(void* handle, const char* name, int parentIndex, bool geometry, int materialIndex);
	virtual int GetModelCount() const;
	virtual void* GetModelHandle(int modelIndex) const;
	virtual const char* GetModelName(int modelIndex) const;
	virtual void SetTranslation(int boneIndex, const float* vec);
	virtual void SetRotation(int boneIndex, const float* vec);
	virtual void SetScale(int boneIndex, const float* vec);

	int GetRootCount() const;
	int GetRootIndex(int rootIndex) const;
	int GetChildCount(int modelIndex) const;
	int GetChildIndex(int modelIndex, int childIndexIndex) const;
	void GetTranslation(float* vec, int modelIndex) const;
	void GetRotation(float* vec, int modelIndex) const;
	void GetScale(float* vec, int modelIndex) const;
	bool HasGeometry(int modelIndex) const;
	int GetMaterialIndex(int modelIndex) const;

private:
	struct ModelEntry
	{
		ModelEntry(void* handle, const std::string& name, int parentIndex, bool geometry, int materialIndex);
		void* handle;
		std::string name;
		int parentIndex;
		bool geometry;
		std::vector<int> children;
		float translation[3];
		float rotation[3];
		float scale[3];
		int materialIndex;
	};

	std::vector<ModelEntry> m_models;
	std::vector<int> m_roots;
};

#endif //__MODELDATA_H__
