#include "StdAfx.h"
#include "SingleAnimationExportSourceAdapter.h"
#include "IGeometryFileData.h"
#include <cassert>

SingleAnimationExportSourceAdapter::SingleAnimationExportSourceAdapter(IExportSource* source, IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex)
: ExportSourceDecoratorBase(source), animationIndex(animationIndex), geometryFileData(geometryFileData), geometryFileIndex(geometryFileIndex)
{
	assert(this->animationIndex < this->source->GetAnimationCount());
}

void SingleAnimationExportSourceAdapter::ReadGeometryFiles(IExportContext* context, IGeometryFileData* geometryFileData)
{
	int geometryFileIndex = geometryFileData->AddGeometryFile(
		this->geometryFileData->GetGeometryFileHandle(this->geometryFileIndex),
		this->geometryFileData->GetGeometryFileName(this->geometryFileIndex),
		this->geometryFileData->GetContentType(this->geometryFileIndex),
		this->geometryFileData->GetFilename(this->geometryFileIndex),
		this->geometryFileData->GetExportSetting(this->geometryFileIndex),
		this->geometryFileData->GetMergeSetting(this->geometryFileIndex));
		
	for (int propertyIndex = 0, propertyCount = this->geometryFileData->GetPropertyCount(this->geometryFileIndex); propertyIndex < propertyCount; ++propertyIndex)
	{
		std::pair<std::string, std::string> property = GetProperty(this->geometryFileData, this->geometryFileIndex, propertyIndex);
		geometryFileData->SetProperty(geometryFileIndex, property.first.c_str(), property.second.c_str());
	}
}

void SingleAnimationExportSourceAdapter::ReadModels(IGeometryFileData* geometryFileData, IMaterialData* materialData, IModelData* modelData, int geometryFileIndex)
{
	assert(geometryFileIndex == 0);
	this->source->ReadModels(this->geometryFileData, materialData, modelData, this->geometryFileIndex);
}

void SingleAnimationExportSourceAdapter::ReadSkinning(IExportContext* context, ISkinningData* skinningData, IModelData* modelData, int modelIndex, ISkeletonData* skeletonData)
{
	this->source->ReadSkinning(context, skinningData, modelData, modelIndex, skeletonData);
}

bool SingleAnimationExportSourceAdapter::ReadSkeleton(IGeometryFileData* geometryFileData, int geometryFileIndex, IModelData* modelData, int modelIndex, const IMaterialData* materialData, ISkeletonData* skeletonData)
{
	assert(geometryFileIndex == 0);
	return this->source->ReadSkeleton(this->geometryFileData, this->geometryFileIndex, modelData, modelIndex, materialData, skeletonData);
}

int SingleAnimationExportSourceAdapter::GetAnimationCount() const
{
	return 1;
}

int SingleAnimationExportSourceAdapter::GetAnimationName(char* buffer, int bufferSize, IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex) const
{
	assert(geometryFileIndex == 0);
	assert(animationIndex == 0);
	return this->source->GetAnimationName(buffer, bufferSize, this->geometryFileData, this->geometryFileIndex, this->animationIndex);
}

void SingleAnimationExportSourceAdapter::GetAnimationTimeSpan(float& start, float& stop, int animationIndex) const
{
	assert(animationIndex == 0);
	this->source->GetAnimationTimeSpan(start, stop, this->animationIndex);
}

void SingleAnimationExportSourceAdapter::ReadAnimationFlags(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex) const
{
	assert(animationIndex == 0);
	this->source->ReadAnimationFlags(context, animationData, geometryFileData, modelData, modelIndex, skeletonData, this->animationIndex);
}

void SingleAnimationExportSourceAdapter::ReadAnimation(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex, float fps) const
{
	assert(animationIndex == 0);
	this->source->ReadAnimation(context, animationData, geometryFileData, modelData, modelIndex, skeletonData, this->animationIndex, fps);
}
