#ifndef __SINGLEANIMATIONEXPORTSOURCEADAPTER_H__
#define __SINGLEANIMATIONEXPORTSOURCEADAPTER_H__

#include "ExportSourceDecoratorBase.h"

class SingleAnimationExportSourceAdapter : public ExportSourceDecoratorBase
{
public:
	SingleAnimationExportSourceAdapter(IExportSource* source, IGeometryFileData* geometryData, int geometryFileIndex, int animationIndex);

	virtual void ReadGeometryFiles(IExportContext* context, IGeometryFileData* geometryFileData);
	virtual void ReadModels(IGeometryFileData* geometryFileData, IMaterialData* materialData, IModelData* modelData, int geometryFileIndex);
	virtual void ReadSkinning(IExportContext* context, ISkinningData* skinningData, IModelData* modelData, int modelIndex, ISkeletonData* skeletonData);
	virtual bool ReadSkeleton(IGeometryFileData* geometryFileData, int geometryFileIndex, IModelData* modelData, int modelIndex, const IMaterialData* materialData, ISkeletonData* skeletonData);
	virtual int GetAnimationCount() const;
	virtual int GetAnimationName(char* buffer, int bufferSize, IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex) const;
	virtual void GetAnimationTimeSpan(float& start, float& stop, int animationIndex) const;
	virtual void ReadAnimationFlags(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex) const;
	virtual void ReadAnimation(IExportContext* context, IAnimationData* animationData, IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex, float fps) const;

private:
	int animationIndex;
	IGeometryFileData* geometryFileData;
	int geometryFileIndex;
};

#endif //__SINGLEANIMATIONEXPORTSOURCEADAPTER_H__
