#ifndef __FILESYSTEMHELPERS_H__
#define __FILESYSTEMHELPERS_H__

#include "Exceptions.h"

namespace FileSystemHelpers
{
	// Declare an exception to report when directory creation operations fail.
	struct DirectoryCreationFailedErrorTag;
	typedef Exception<DirectoryCreationFailedErrorTag> DirectoryCreationFailedError;

	unsigned GetFileFlags(const std::string& path);
	void EnsureDirectoryExists(const std::string& directory);
}

#endif //__FILESYSTEMHELPERS_H__
