#ifndef __PATH_H__
#define __PATH_H__

namespace PathHelpers
{
	string FindExtension(const string& path);
	string ReplaceExtension(const string& path, const string& newExtension);
	string RemoveExtension(const string& path);
	string GetDirectory(const string& path);
	string GetFilename(const string& path);
	string AddSeparator(const string& path);
	string RemoveSeparator(const string& path);
	string Join(const string& path1, const string& path2);
	string GetParentDirectory(const string& path);
	bool MatchWildcard(const string& text, const string& wildcard);
	bool IsRelative(const string& path);
}

#endif //__PATH_H__
