#include "StdAfx.h"
#include "StringHelpers.h"
#include <cctype>
#include <algorithm>

bool StringHelpers::StartsWith(const string& str, const string& pattern)
{
	if (str.size() < pattern.size())
		return false;
	return std::memcmp(&str[0], &pattern[0], pattern.size()) == 0;
}

string StringHelpers::TrimLeft(const string& s)
{
	size_t first = s.find_first_not_of(" \r\t");
	return s.substr(first);
}

string StringHelpers::TrimRight(const string& s)
{
	size_t last = 0;
	for (size_t i = 0; i < s.size(); ++i)
		if (strchr(" \r\t", s[i]) == 0)
			last = i + 1;
	return s.substr(0, last);
}

string StringHelpers::Trim(const string& s)
{
	return TrimLeft(TrimRight(s));
}

string StringHelpers::MakeLowerCase(const string& s)
{
	string copy = s;
	std::transform(copy.begin(), copy.end(), copy.begin(), std::tolower);
	return copy;
}

string StringHelpers::MakeUpperCase(const string& s)
{
	string copy = s;
	std::transform(copy.begin(), copy.end(), copy.begin(), std::toupper);
	return copy;
}

string StringHelpers::Replace(const string& s, char oldChar, char newChar)
{
	string copy = s;
	std::replace(copy.begin(), copy.end(), oldChar, newChar);
	return copy;
}
