#include "stdafx.h"
#include "XMLPakFileSink.h"

XMLPakFileSink::XMLPakFileSink(IPakSystem* pakSystem, const std::string& archivePath, const std::string& filePath)
:	pakSystem(pakSystem),
	filePath(filePath)
{
	archive = pakSystem->OpenArchive(archivePath.c_str());
}

XMLPakFileSink::~XMLPakFileSink()
{
	if (archive && pakSystem)
	{
		pakSystem->AddToArchive(archive, filePath.c_str(), &data[0], int(data.size()));
		pakSystem->CloseArchive(archive);
	}
}

void XMLPakFileSink::Write(const char* text)
{
	int len = int(strlen(text));
	int start = int(data.size());
	data.resize(data.size() + len);
	memcpy(&data[start], text, len);
}
