import sys, getopt
import crymp

class Options:
  """Class holding al runtime options and flags.

  All options are kept in static class variables, there are no instances of
  this class.
  """

  DRIVER_SINGLECORE = 'singlecore'
  DRIVER_MULTICORE = 'multicore'
  DRIVER_PS3 = 'ps3'

  verbose = 0
  verbose_file = 2
  debug = 0
  basename = None
  prefix = 'CryMP'
  output_dir = None
  log_filename = None
  annotation_file_list = [ ]

  output_indent = 0
  shift_width = 2
  tab_size = 2

  driver = DRIVER_MULTICORE
  skel_filename = 'crymp.skel'
  skel = None

  def __init__(self):
    raise ValueError, 'class Options may not be instanciated'

  def help():
    """Return the options help text.
    """

    # XXX
    return 'Options.help()\n'

  help = staticmethod(help)

  def parse(argv):
    """Parse the command line options.

    :Parameters:
      - `argv`: The command line argument vector.  Typically 'sys.argv[1:]'.
    """
    
    opts, args = getopt.getopt(
	sys.argv[1:],
	'hVvsn:d:t:a:x:',
	[ 'help', 'version', 'verbose', 'silent',
	  'name=', 'dir=', 'tabsize=', 'annotation=', 'driver=' ])
    for a, o in opts:
      if a in ('-h', '--help'):
	crymp.main.version(sys.stdout)
	crymp.main.help(sys.stdout)
	sys.exit(0)
      elif a in ('-V', '--version'):
	crymp.main.version(sys.stdout)
	sys.exit(0)
      elif a in ('-v', '--verbose'):
	Options.verbose += 1
      elif a in ('-s', '--silent'):
	Options.verbose = -1
      elif a in ('-n', '--name'):
	Options.basename = o
      elif a in ('-d', '--dir'):
	Options.output_dir = o
      elif a in ('-t', '--tabsize'):
	try:
	  Options.tab_size = int(o)
	except:
	  Options.tab_size = -1
      elif a in ('-a', '--annotation'):
        Options.annotation_file_list.append(o)
      elif a in ('-x', '--driver'):
        if o in ('m', 'multi', 'multicore'):
	  Options.driver = Options.DRIVER_MULTICORE
	elif o in ('s', 'single', 'singlecore'):
	  Options.driver = Options.DRIVER_SINGLECORE
	elif o in ('ps3', 'playstation3'):
	  Options.driver = Options.DRIVER_PS3
	else:
	  crymp.error('Unknown output driver ' + repr(o))
	  sys.exit(1)
      else:
	crymp.error('Unrecognized option ' + repr(a))
	sys.exit(1)
    if Options.tab_size < 1 or Options.tab_size > 100:
      crymp.error('Invalid tab size ' + repr(o) + ' specified')
      sys.exit(1)
    if Options.output_dir is None:
      Options.output_dir = '.'
    elif not os.path.isdir(Options.output_dir):
      crymp.error('Invalid output directory ' + repr(Options.output_dir))
      sys.exit(1)
    if len(args) == 0:
      crymp.error('No input files.')
      sys.exit(1)
    if Options.basename is None:
      Options.basename = 'CryMP_out'
      crymp.info(
	  'Using default basename ' + repr(Options.basename),
	  level = 1)

    return args

  parse = staticmethod(parse)

