import sys, re, string, types
import crymp

def process(block):
  # The run method of the single-core output just calls the job implementation
  # methods in the order of the topologically sorted job list.  No special
  # processing needs to be done to prepare this step.

  pass

def run_body(block, skel, context):
  # Return the body of the run method for single core output.
  
  s = skel.expand('sc_run_prologue', context)
  for job in block.jobs:
    job_context = job.get_context(context)
    if isinstance(job.element, crymp.parse.PSection):
      s += skel.expand('sc_run_section', job_context)
    elif isinstance(job.element, crymp.parse.PLoop):
      s += skel.expand('sc_run_loop', job_context)
    elif isinstance(job.element, crymp.parse.PLocal):
      s += skel.expand('sc_run_local', job_context)
  s += skel.expand('sc_run_epilogue', context)
  return s

def job_decl(job, skel, context, scope):
  # Get the job declaration code.

  s = ''
  element = job.element
  job_context = job.get_context(context)
  if isinstance(element, crymp.parse.PLocal):
    if scope == 'shared':
      s += skel.expand('sc_jobdecl_local', job_context)
  elif isinstance(element, crymp.parse.PSection):
    if scope == 'local':
      s += skel.expand('sc_jobdecl_section_local', job_context)
    else:
      assert scope == 'shared'
      s += skel.expand('sc_jobdecl_section', job_context)
  elif isinstance(element, crymp.parse.PLoop):
    if scope == 'local':
      s += skel.expand('sc_jobdecl_loop_local', job_context)
    else:
      assert scope == 'shared'
      s += skel.expand('sc_jobdecl_loop', job_context)
  return s

def job_def(job, skel, context, scope):
  # Get the job definition code.

  s = ''
  element = job.element
  job_context = job.get_context(context)
  if isinstance(element, crymp.parse.PLocal):
    if scope == 'shared':
      s += skel.expand('sc_jobdef_local', job_context)
  elif isinstance(element, crymp.parse.PSection):
    if scope == 'local':
      s += skel.expand('sc_jobdef_section_local', job_context)
    else:
      assert scope == 'shared'
      s += skel.expand('sc_jobdef_section', job_context)
  elif isinstance(element, crymp.parse.PLoop):
    if scope == 'local':
      s += skel.expand('sc_jobdef_loop_local', job_context)
    else:
      assert scope == 'shared'
      s += skel.expand('sc_jobdef_loop', job_context)
  return s

