// CryViewerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CryViewer.h"
#include "CryViewerDlg.h"
#include "Node.h"
#include "Geom.h"
#include "Light.h"
#include "Helper.h"
#include "BoneNameList.h"
#include "Controller.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#pragma warning( disable : 4244)

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCryViewerDlg dialog

CCryViewerDlg::CCryViewerDlg(CWnd* pParent /*=NULL*/) : CDialog(CCryViewerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCryViewerDlg)
	//}}AFX_DATA_INIT
	m_hIcon				= AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	nObjects			= 0;
	AllObjects			= NULL;
	ngeoms				= 0;
	npatches			= 0;
	ox					= 100;
	oy					= 300;
	zoom				= 1.0f;
	Alpha				= 0.0f;
	Beta				= 0.0f;
	nGeomBoneList		= 0;
	GeomBoneList		= NULL;

	play_TicksPerFrame	= 160;
	play_SecsPerTick	= 1.0f/30/160;
	play_start_time		= 0;
	play_end_time		= 100*160;


	prevpoint.x=prevpoint.y=startpoint.x=startpoint.y=0;

	BluePen=CreatePen(PS_SOLID,0,RGB(0,0,128));

	UpdateTM();
}

CCryViewerDlg::~CCryViewerDlg()
{
	DeleteObject(BluePen);
	for(int i=0;i<nObjects;i++)
	{
		delete AllObjects[i];
	}
}

void CCryViewerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCryViewerDlg)
	DDX_Control(pDX, IDC_NORMAL_SIZE, m_normal_size);
	DDX_Control(pDX, IDC_REFRESH_RATE, m_refrate);
	DDX_Control(pDX, IDC_SPEED, m_speed);
	DDX_Control(pDX, IDC_AUTO_DEFORM, m_AutoDeform);
	DDX_Control(pDX, IDC_TIME, m_Time);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCryViewerDlg, CDialog)
	//{{AFX_MSG_MAP(CCryViewerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_LOADGEOM, OnLoadgeom)
	ON_WM_DRAWITEM()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_BN_CLICKED(IDC_XY, OnViewpointXY)
	ON_BN_CLICKED(IDC_XZ, OnViewpointXZ)
	ON_BN_CLICKED(IDC_YZ, OnViewpointYZ)
	ON_BN_CLICKED(IDC_LOADBONES, OnLoadbones)
	ON_BN_CLICKED(IDC_ZOOM_EXTENTS, OnZoomExtents)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_DISP_BONE, Redraw)
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_EN_CHANGE(IDC_NORMAL_SIZE, OnChangeNormalSize)
	ON_BN_CLICKED(IDC_NORMALS, OnNormals)
	ON_BN_CLICKED(IDC_DISP_FACES, Redraw)
	ON_BN_CLICKED(IDC_DISP_VERTS, Redraw)
	ON_BN_CLICKED(IDC_VERT_NO, OnVertNo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCryViewerDlg message handlers

BOOL CCryViewerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	CheckDlgButton(IDC_DISP_BONE, true);
	CheckDlgButton(IDC_DISP_VERTS, true);
	CheckDlgButton(IDC_DISP_FACES, true);
	CheckDlgButton(IDC_AUTO_DEFORM, true);
	CheckDlgButton(IDC_SUB_FRAMES, true);

	m_speed.SetWindowText("1.0");
	m_refrate.SetWindowText("30");
	m_normal_size.SetWindowText("1.0");

	HWND tmp=GetDlgItem(IDC_ZOOM_EXTENTS)->m_hWnd;
	::SetFocus(tmp);
	::SetActiveWindow(tmp);
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCryViewerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
		//Beep(1000,100);
	}
}

void CCryViewerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CCryViewerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

int CCryViewerDlg::LoadNameList(FILE *f,long pos, NAME_ENTITY **table)
{
	if(fseek(f,pos,SEEK_SET)) return -1;

	GEOMNAMELIST_CHUNK_DESC chunk;
	int res=fread(&chunk,sizeof(chunk),1,f);
	if(res!=1) return -1;

	int n=chunk.nEntities;

	*table=(NAME_ENTITY *)calloc(sizeof(NAME_ENTITY),n);
	assert(table);

	res=fread(*table,sizeof(NAME_ENTITY),n,f);
	if(res!=n) return -1;

	return n;
};

void CCryViewerDlg::OnLoadgeom() 
{
	static char		FileName[256];
	FileName[0]=0;

	OPENFILENAME	ofn;	

	//Set dialog box options
	ofn.lStructSize       = sizeof(OPENFILENAME);
	ofn.hwndOwner         = m_hWnd;
	ofn.hInstance         = NULL;	
	ofn.lpstrTitle        = NULL;
	ofn.lpstrFilter       = "Crytek Geometry File (*.cgf)\0*.cgf\0Any File\0*.*\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter    = 0;
	ofn.nFilterIndex      = 0;
	ofn.lpstrFile         = FileName;
	ofn.nMaxFile          = sizeof(FileName);
	ofn.lpstrFileTitle    = NULL;
	ofn.nMaxFileTitle     = 0;
	ofn.lpstrInitialDir   = NULL;
	ofn.Flags             = OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST|OFN_HIDEREADONLY;
	ofn.nFileOffset       = 0;
	ofn.nFileExtension    = 0;
	ofn.lpstrDefExt       = "txt";
	ofn.lCustData         = 0;
	ofn.lpfnHook          = NULL;
	ofn.lpTemplateName    = NULL;

	if(!GetOpenFileName(&ofn))
	{
		return ; //cancelled (no error though, it is ok)
	}

	FILE *f=fopen(FileName,"rb");
	if(!f)
	{
		MessageBox("Can not open file",FileName);
		return;
	}

	//read the file header
	FILE_HEADER fh;
	int res=fread(&fh,sizeof(fh),1,f);
	if(res!=1) return;

	if(fh.Version != GeomFileVersion || fh.FileType != FileType_Geom) 
	{
		fclose(f);
		return;
	}



	//read the chunk table
	fseek(f,fh.ChunkTableOffset,SEEK_SET);
	int n_chunks;
	res=fread(&n_chunks,sizeof(n_chunks),1,f);
	if(res!=1) return;
	CHUNK_HEADER *chunks;
	chunks=(CHUNK_HEADER *)calloc(sizeof(CHUNK_HEADER),n_chunks);
	assert(chunks);
	res=fread(chunks,sizeof(CHUNK_HEADER),n_chunks,f);
	if(res!=n_chunks) return;

	//create list for new objects
	BaseObj ** new_objs = (BaseObj **)calloc(n_chunks,sizeof(BaseObj *));
	assert(new_objs);

	int nNewObjs=0;
	BoneNameList *bonenamelist=NULL;
	//create and load objects
	for(int i=0;i<n_chunks;i++)
	{
		switch(chunks[i].ChunkType)
		{
		case ChunkType_Timing:
			{
				TIMING_CHUNK_DESC cd;
				fseek(f,chunks[i].FileOffset, SEEK_SET);
				res=fread(&cd,sizeof(cd),1,f);
				if(res!=1) return;
				play_TicksPerFrame	= cd.TicksPerFrame;
				play_SecsPerTick	= cd.SecsPerTick;
				play_start_time		= cd.global_range.start* play_TicksPerFrame;
				play_end_time		= cd.global_range.end* play_TicksPerFrame;
				UpdateTimeSliderRange();
			}
			break;

		case ChunkType_Node:
			new_objs[nNewObjs]=new CNode();
			break;

		case ChunkType_Controller:
			new_objs[nNewObjs]=new Controller();
			break;

		case ChunkType_Mesh:
			new_objs[nNewObjs]=new Geom();
			break;

		case ChunkType_Helper:
			new_objs[nNewObjs]=new CHelper();
			break;

		case ChunkType_Light:
			new_objs[nNewObjs]=new CLight();
			break;

		case ChunkType_BoneNameList:
			new_objs[nNewObjs]=bonenamelist=new BoneNameList();
			break;
		}

		if(new_objs[nNewObjs])
		{
			new_objs[nNewObjs]->Load(f,chunks[i].FileOffset);
			nNewObjs++;
		}
	}

	//Do pointer and name list bindings
	for(i=0;i<nNewObjs;i++)
	{
		if(!new_objs[i]) continue;
		new_objs[i]->Bind(new_objs, nNewObjs);
	}

	fclose(f);

	//append the new loaded objects to the allAbjects list
	AllObjects = (BaseObj **)realloc(AllObjects, (nNewObjs+nObjects)*sizeof(BaseObj *));
	assert(AllObjects);
	for(i=nObjects;i<(nNewObjs+nObjects);i++)
	{
		AllObjects[i]=new_objs[i-nObjects];
	}
	nObjects+=nNewObjs;


	if(new_objs) free(new_objs);
	if(chunks) free(chunks);
	OnZoomExtents();
	Redraw();
}

void CCryViewerDlg::OnLoadbones() 
{
	// TODO: Add your control notification handler code here
	static char		FileName[256];
	FileName[0]=0;

	OPENFILENAME	ofn;	

	//Set dialog box options
	ofn.lStructSize       = sizeof(OPENFILENAME);
	ofn.hwndOwner         = m_hWnd;
	ofn.hInstance         = NULL;	
	ofn.lpstrTitle        = NULL;
	ofn.lpstrFilter       = "Crytek Animation File (*.caf)\0*.caf\0Any File\0*.*\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter    = 0;
	ofn.nFilterIndex      = 0;
	ofn.lpstrFile         = FileName;
	ofn.nMaxFile          = sizeof(FileName);
	ofn.lpstrFileTitle    = NULL;
	ofn.nMaxFileTitle     = 0;
	ofn.lpstrInitialDir   = NULL;
	ofn.Flags             = OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST|OFN_HIDEREADONLY;
	ofn.nFileOffset       = 0;
	ofn.nFileExtension    = 0;
	ofn.lpstrDefExt       = "txt";
	ofn.lCustData         = 0;
	ofn.lpfnHook          = NULL;
	ofn.lpTemplateName    = NULL;

	if(!GetOpenFileName(&ofn))
	{
		return ; //cancelled (no error though, it is ok)
	}

	FILE *f=fopen(FileName,"rb");
	if(!f)
	{
		MessageBox("Can not open file",FileName);
		return;
	}

	//read the file header
	FILE_HEADER fh;
	int res=fread(&fh,sizeof(fh),1,f);
	if(res!=1) return;

	//read the chunk table
	fseek(f,fh.ChunkTableOffset,SEEK_SET);
	int n_chunks;
	res=fread(&n_chunks,sizeof(n_chunks),1,f);
	if(res!=1) return;
	CHUNK_HEADER *chunks;
	chunks=(CHUNK_HEADER *)calloc(sizeof(CHUNK_HEADER),n_chunks);
	assert(chunks);
	res=fread(chunks,sizeof(CHUNK_HEADER),n_chunks,f);
	if(res!=n_chunks) return;

	//create list for new objects
	BaseObj ** new_objs = (BaseObj **)calloc(n_chunks,sizeof(BaseObj *));
	assert(new_objs);


	//check chunks
	int nNewObjs=0;
	BoneNameList	*bonenamelist=NULL;
	Bone			*boneanimroot=NULL;
	for(int i=0;i<n_chunks;i++)
	{
		switch(chunks[i].ChunkType)
		{
		case ChunkType_Timing:
			{
				TIMING_CHUNK_DESC cd;
				fseek(f,chunks[i].FileOffset, SEEK_SET);
				res=fread(&cd,sizeof(cd),1,f);
				if(res!=1) return;
				play_TicksPerFrame	= cd.TicksPerFrame;
				play_SecsPerTick	= cd.SecsPerTick;
				play_start_time		= cd.global_range.start* play_TicksPerFrame;
				play_end_time		= cd.global_range.end* play_TicksPerFrame;
				UpdateTimeSliderRange();
			}
			break;

		case ChunkType_BoneAnim:
			new_objs[nNewObjs]=boneanimroot=new Bone();
			break;

		case ChunkType_BoneNameList:
			new_objs[nNewObjs]=bonenamelist=new BoneNameList();
			break;

		case ChunkType_Controller:
			new_objs[nNewObjs]=new Controller();
			break;
		}

		if(new_objs[nNewObjs])
		{
			new_objs[nNewObjs]->Load(f,chunks[i].FileOffset);
			nNewObjs++;
		}
	}

	//Do pointer and name list bindings
	for(i=0;i<nNewObjs;i++)
	{
		if(!new_objs[i]) continue;
		new_objs[i]->Bind(new_objs, nNewObjs);
	}

	//append the new loaded objects to the allAbjects list
	AllObjects = (BaseObj **)realloc(AllObjects, (nNewObjs+nObjects)*sizeof(BaseObj *));
	assert(AllObjects);
	for(i=nObjects;i<(nNewObjs+nObjects);i++)
	{
		AllObjects[i]=new_objs[i-nObjects];
	}
	nObjects+=nNewObjs;

	ConstructGeomBoneList();
	
	if(chunks)		free(chunks);
	if(new_objs)	free(new_objs);
	fclose(f);

	UpdateTimeSliderRange();
	
	OnZoomExtents();
	Redraw();
}


void CCryViewerDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDS) 
{
	// TODO: Add your message handler code here and/or call default
	
	static int sw_count=0;
	static int sw_total=0;
	int sw_start=GetTickCount();
	HDC hpdc=lpDS->hDC;

	int w=lpDS->rcItem.right-lpDS->rcItem.left;
	int h=lpDS->rcItem.bottom-lpDS->rcItem.top;

	//Double buffer
	HDC hdc=CreateCompatibleDC(hpdc);
	HBITMAP hbitmap=CreateCompatibleBitmap(hpdc,w,h);
	SelectObject(hdc,hbitmap);

	FillRect(hdc,&lpDS->rcItem, (HBRUSH)GetStockObject(GRAY_BRUSH));

	extents.SetRectEmpty();
	extents.bottom = extents.right = -1000000;
	extents.top= extents.left= 1000000;

	char s[64];
	SelectObject(hdc,GetStockObject(BLACK_PEN));
	m_normal_size.GetWindowText(s,63);

	DispOptions opt;
	opt.NormalSize	= float(atof(s));
	opt.ShowFaces	= IsDlgButtonChecked(IDC_DISP_FACES)?true:false;
	opt.ShowNormals	= IsDlgButtonChecked(IDC_NORMALS)?true:false;
	opt.ShowVertNo	= IsDlgButtonChecked(IDC_VERT_NO)?true:false;
	opt.ShowVerts	= IsDlgButtonChecked(IDC_DISP_VERTS)?true:false;
	opt.vtm			= tm;
	opt.tm			= tm;
	opt.Interpolate	= !IsDlgButtonChecked(IDC_BONE_AT_KEYS);
	opt.time		= m_Time.GetPos();
	//SetBkMode(hdc, TRANSPARENT);

	for(int i=0;i<nObjects;i++)
	{
		//Paint only the orphan nodes: parents will call children's and objects' paint method.
		BaseObj *obj=AllObjects[i];
		if(!obj) continue;

		if(obj->hdr.ChunkType == ChunkType_Node && !((CNode*)obj)->Parent)
		{
			CRect bb=obj->Paint(hdc,opt);
			extents.UnionRect(extents,bb);
		}

		if(obj->hdr.ChunkType == ChunkType_BoneAnim)
		{
			CRect bb=obj->Paint(hdc,opt);
			extents.UnionRect(extents,bb);
		}

	}

	SelectObject(hdc,BluePen);

	/*
	for(i=0;i<npatches;i++)
	{
		CRect bb=patches[i]->Paint(hdc,tm, opt.ShowFaces, opt.ShowVerts);
		extents.UnionRect(extents,bb);
	}
	*/

	BitBlt(hpdc,0,0,w,h,hdc,0,0,SRCCOPY);

	DeleteObject(hbitmap);
	DeleteDC(hdc);

	sw_total +=GetTickCount()-sw_start;
	sw_count ++;
	if(sw_count >=25)
	{
		char s[32];
		float fps= (1000.0f * sw_count)/ sw_total;
		sprintf(s,"%0.2f",fps);
		
		SetDlgItemText(IDC_DRAW_FPS,s);
		sw_total=sw_count=0;
	}
}

void CCryViewerDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	if((nFlags & MK_LBUTTON) && (nFlags &MK_RBUTTON))
	{
		float px=(startpoint.x-ox)/zoom;
		float py=(oy-startpoint.y)/zoom;
		float zk=(float)exp(-.05*(point.y-prevpoint.y));
		zoom*=zk;

		float nx=ox+px*zoom;
		float ny=oy-py*zoom;

		ox-=int(nx-startpoint.x);
		oy-=int(ny-startpoint.y);

		Redraw();
	}
	else if(nFlags & MK_LBUTTON)
	{
		Beta  +=(point.x-prevpoint.x)/1.0f;
		Alpha +=(point.y-prevpoint.y)/2.0f;
		Redraw();
	}
	else if(nFlags & MK_RBUTTON)
	{
		ox+=point.x-prevpoint.x;
		oy+=point.y-prevpoint.y;

		Redraw();
	}

	UpdateTM();

	prevpoint=point;
	CDialog::OnMouseMove(nFlags, point);
}

void CCryViewerDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	prevpoint=startpoint=point;
	CDialog::OnLButtonDown(nFlags, point);
}

void CCryViewerDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	prevpoint=startpoint=point;
	CDialog::OnRButtonDown(nFlags, point);
}

void CCryViewerDlg::OnViewpointXY() 
{
	Alpha= 0.0f; 
	Beta= 0.0f; 
	UpdateTM();

	OnZoomExtents();
}

void CCryViewerDlg::OnViewpointYZ() 
{
	Alpha= -90.0f;  
	Beta= 90.0f; 
	UpdateTM();

	OnZoomExtents();
}

void CCryViewerDlg::OnViewpointXZ() 
{
	Alpha= -90.0f;  
	Beta= 0.0f;
	UpdateTM();

	OnZoomExtents();
}

void CCryViewerDlg::ConstructGeomBoneList()
{
	//find latest loaded skeleton
	BaseObj* root=NULL;
	for(int i=0;i<nObjects;i++)
	{
		BaseObj *o=AllObjects[i];
		if(o->hdr.ChunkType == ChunkType_BoneAnim) root=(Bone*)o;
	}
	if(!root) return;

	for(i=0;i<nObjects;i++)
	{
		BaseObj *o=AllObjects[i];
		if(o->hdr.ChunkType == ChunkType_Mesh)
		{
			o->Bind(&root,1);
		}
	}
}

void CCryViewerDlg::OnZoomExtents() 
{
	RedrawNow();

	RECT r;
	GetDlgItem(IDC_VIEWPORT)->GetClientRect(&r);

	int rw=r.right-r.left;
	int rh=r.bottom-r.top;

	int ew=extents.right-extents.left;
	int eh=extents.bottom-extents.top;

	float zk=0.9f*min(float(rw)/ew, float(rh)/eh);
	zoom *= zk;

	ox-= ((extents.left+extents.right) - r.left-r.right )/2;
	oy-= ((extents.top+extents.bottom) - r.top -r.bottom)/2;

	UpdateTM();

	Redraw();
}

void CCryViewerDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	TimeChanged();
}

void CCryViewerDlg::OnPlay() 
{
	KillTimer(1);

	char s[64];
	m_refrate.GetWindowText(s,63);
	int fps=atoi(s);

	if(IsDlgButtonChecked(IDC_PLAY))
	{
		SetTimer(1,1000/fps,NULL);
		m_refrate.EnableWindow(false);
	}
	else
	{
		m_refrate.EnableWindow(true);

	}
}

void CCryViewerDlg::OnTimer(UINT nIDEvent) 
{
	char s[64];
	m_speed.GetWindowText(s,63);
	float speed=atof(s);

	m_refrate.GetWindowText(s,63);
	int fps=atoi(s);

	
	int inc= (speed/fps) / play_SecsPerTick;
	
	if(m_Time.GetRangeMax())
		m_Time.SetPos((m_Time.GetPos()+inc) % m_Time.GetRangeMax());
	else
		m_Time.SetPos(0);

	TimeChanged();
}

void CCryViewerDlg::TimeChanged()
{
	int tick_time		= m_Time.GetPos();
	int time=tick_time;

	for(int i=0;i<nObjects;i++)
	{
		BaseObj *obj= (BaseObj *)AllObjects[i];
		switch(obj->hdr.ChunkType)
		{
		case ChunkType_BoneAnim:
			((Bone *)obj)->Pose(tick_time);
			break;

		case ChunkType_Node:
			((CNode *)obj)->Pose(tick_time);
			break;
		}
	}

	for(i=0;i<nObjects;i++)
	{
		Geom *o=(Geom *)AllObjects[i];
		if(o->hdr.ChunkType == ChunkType_Mesh) o->Deform();		
	}

	Redraw();
}


void CCryViewerDlg::Redraw() 
{
	GetDlgItem(IDC_VIEWPORT)->Invalidate(false);
}

void CCryViewerDlg::RedrawNow() 
{
	GetDlgItem(IDC_VIEWPORT)->Invalidate(FALSE);
	GetDlgItem(IDC_VIEWPORT)->UpdateWindow();
}

void CCryViewerDlg::UpdateTimeSliderRange()
{
	m_Time.SetRange(play_start_time, play_end_time, true);
}

void CCryViewerDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
	EndDialog(false);
}

void CCryViewerDlg::UpdateTM()
{
	CryPoint3 pp;
	pp.x=ox;
	pp.y=oy;
	pp.z=0.0f;

	tm.Init();
	tm.data[5]=-1.0f;

	tm.Scale(zoom);
	tm.RotateX(Alpha);
	tm.RotateZ(Beta);
	tm.Translate(pp);
}

void CCryViewerDlg::OnChangeNormalSize() 
{
	Redraw();
}

void CCryViewerDlg::OnNormals() 
{
	Redraw();
}

void CCryViewerDlg::OnVertNo() 
{
	Redraw();	
}
